% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_fun.R
\name{is_vector}
\alias{is_vector}
\title{Test for a vector (i.e., atomic vector or list).}
\usage{
is_vector(x)
}
\arguments{
\item{x}{Vector(s) to test (required).}
}
\description{
\code{is_vector} tests if \code{x} is a vector.
}
\details{
\code{is_vector} does what the \strong{base} R function \code{is.vector} is \strong{not} designed to do: 

\itemize{ 
  \item \code{is_vector()} returns TRUE if \code{x} is an atomic vector or a list (irrespective of its attributes). 

  \item \code{is.vector()} returns TRUE if \code{x} is a vector of the specified \code{mode} having no attributes other than names, otherwise FALSE.
}

Internally, the function is a wrapper for \code{is.atomic(x) | is.list(x)}. 

Note that data frames are also vectors.

See the documentations of \code{\link{is.atomic}}, \code{\link{is.list}}, and \code{\link{is.vector}} for details.
}
\examples{
# Define 3 types of vectors:
v1 <- 1:3  # (a) atomic vector
names(v1) <- LETTERS[v1]  # with names

v2 <- v1   # (b) copy vector
attr(v2, "my_attr") <- "foo"  # add an attribute
ls <- list(1, 2, "C")  # (c) list

# Compare:
is.vector(v1)
is.list(v1)
is_vector(v1)

is.vector(v2)  # FALSE
is.list(v2)
is_vector(v2)  # TRUE

is.vector(ls)
is.list(ls)
is_vector(ls)

# Data frames are also vectors: 
df <- as.data.frame(1:3)
is_vector(df)  # is TRUE

}
\seealso{
\code{\link{is.atomic}} function of the R \strong{base} package; 
\code{\link{is.list}} function of the R \strong{base} package;  
\code{\link{is.vector}} function of the R \strong{base} package.

Other utility functions: 
\code{\link{is_equal}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}
}
\concept{utility functions}
