% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multitrial_normal.R
\name{utility23_normal}
\alias{utility23_normal}
\title{Utility function for multitrial programs deciding between two or three phase III trials for a normally distributed outcome}
\usage{
utility23_normal(
  n2,
  kappa,
  w,
  Delta1,
  Delta2,
  in1,
  in2,
  a,
  b,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  b1,
  b2,
  b3
)
}
\arguments{
\item{n2}{total sample size for phase II; must be even number}

\item{kappa}{threshold value for the go/no-go decision rule}

\item{w}{weight for mixture prior distribution}

\item{Delta1}{assumed true treatment effect for standardized difference in means}

\item{Delta2}{assumed true treatment effect for standardized difference in means}

\item{in1}{amount of information for \code{Delta1} in terms of sample size}

\item{in2}{amount of information for \code{Delta2} in terms of sample size}

\item{a}{lower boundary for the truncation}

\item{b}{upper boundary for the truncation}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}
}
\value{
The output of the function utility23_normal() is the expected utility of the program depending on whether two or three phase III trials are performed.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in a further step maximized by the \code{optimal_multitrial_normal()} function.
}
\examples{
\donttest{utility23_normal(n2 = 50, kappa = 0.2, w = 0.3, alpha = 0.025, beta = 0.1,
                                Delta1 = 0.375, Delta2 = 0.625, in1 = 300, in2 = 600, 
                                a = 0.25, b = 0.75, 
                                c2 = 0.675, c3 = 0.72, c02 = 15, c03 = 20,
                                b1 = 3000, b2 = 8000, b3 = 10000)}
}
\keyword{internal}
