% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiarm.R
\name{ss_tte}
\alias{ss_tte}
\title{Total sample size for phase III trial with l treatments and equal allocation ratio for time-to-event outcomes}
\usage{
ss_tte(alpha, beta, ec, ek, y, l)
}
\arguments{
\item{alpha}{significance level}

\item{beta}{1-beta power for calculation of sample size for phase III}

\item{ec}{control arm event rate for phase II and III}

\item{ek}{event rate of arm k (either arm 1 or arm 2)}

\item{y}{hat_theta_2; estimator in phase II}

\item{l}{number of treatments in phase III:
\itemize{
\item l=1: according to Schoenfeld to guarantee power for the log rank test to detect treatment effect of phase II;
\item l=2: according to Dunnett to guarantee y any-pair power (Horn & Vollandt)
}}
}
\value{
the function ss_tte() returns the total sample size for phase III trial with l treatments and equal allocation ratio
}
\description{
Depending on the results of phase II and our strategy ,i.e. whether we proceed only with the best promising treatment (l = 1) or with all promising treatments (l = 2), this program calculates the number of participants in phase III.

l=1: according to Schoenfeld to guarantee power for the log rank test to detect treatment effect of phase II;

l=2: according to Dunnett to guarantee y any-pair power (Horn & Vollandt)
}
\examples{
res <- ss_tte(alpha = 0.05, beta = 0.1, ec = 0.6, ek = 0.8, y = 0.5, l=1)
}
\keyword{internal}
