% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_multiarm_binary.R
\name{optimal_multiarm_binary}
\alias{optimal_multiarm_binary}
\title{Optimal phase II/III drug development planning for multi-arm programs with
binary endpoint}
\usage{
optimal_multiarm_binary(
  p0,
  p11,
  p12,
  n2min,
  n2max,
  stepn2,
  rrgomin,
  rrgomax,
  steprrgo,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  steps1 = 1,
  stepm1 = 0.95,
  stepl1 = 0.85,
  b1,
  b2,
  b3,
  strategy,
  num_cl = 1
)
}
\arguments{
\item{p0}{assumed true rate of the control group}

\item{p11}{assumed true rate of the treatment arm 1}

\item{p12}{assumed true rate of treatment arm 2}

\item{n2min}{minimal total sample size in phase II, must be divisible by 3}

\item{n2max}{maximal total sample size in phase II, must be divisible by 3}

\item{stepn2}{stepsize for the optimization over n2, must be divisible by 3}

\item{rrgomin}{minimal threshold value for the go/no-go decision rule}

\item{rrgomax}{maximal threshold value for the go/no-go decision rule}

\item{steprrgo}{step size for the optimization over RRgo}

\item{alpha}{one-sided significance level/family-wise error rate}

\item{beta}{type-II error rate for any pair, i.e. \code{1 - beta} is the (any-pair) power for calculation of the sample size for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: \code{Inf}, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: \code{Inf}, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: \code{-Inf}, e.g. no constraint}

\item{steps1}{lower boundary for effect size category "small" in RR scale, default: 1}

\item{stepm1}{lower boundary for effect size category "medium" in RR scale = upper boundary for effect size category "small" in RR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category "large" in RR scale = upper boundary for effect size category "medium" in RR scale, default: 0.85}

\item{b1}{expected gain for effect size category "small"}

\item{b2}{expected gain for effect size category "medium"}

\item{b3}{expected gain for effect size category "large"}

\item{strategy}{choose strategy: 1 (only the best promising candidate), 2 (all promising candidates) or 3 (both strategies)}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\value{
The output of the function is a \code{data.frame} object containing the optimization results:
\describe{\item{Strategy}{Strategy, 1: "only best promising" or 2: "all promising"}\item{u}{maximal expected utility under the optimization constraints, i.e. the expected utility of the optimal sample size and threshold value}\item{RRgo}{optimal threshold value for the decision rule to go to phase III}\item{n2}{total sample size for phase II; rounded to the next even natural number}
\item{n3}{total sample size for phase III; rounded to the next even natural number}
\item{n}{total sample size in the program; n = n2 + n3}
\item{K}{maximal costs of the program (i.e. the cost constraint, if it is set or the sum K2+K3 if no cost constraint is set)}
\item{pgo}{probability to go to phase III}
\item{sProg}{probability of a successful program}\item{sProg2}{probability of a successful program with two arms in phase III}
\item{sProg3}{probability of a successful program with three arms in phase III}\item{K2}{expected costs for phase II}
\item{K3}{expected costs for phase III}}
and further input parameters. Taking \code{cat(comment())} of the
data frame lists the used optimization sequences, start and
finish date of the optimization procedure.
}
\description{
The \code{\link{optimal_multiarm_binary}} function enables planning of
multi-arm phase II/III drug
development programs with optimal sample size allocation and go/no-go
decision rules. For binary endpoints the treatment effect is measured by the
risk ratio (RR). So far, only three-arm trials with two treatments and one
control are supported. The assumed true treatment effects can be assumed fixed
or modelled by a prior distribution. The R Shiny application
\href{https://web.imbi.uni-heidelberg.de/prior/}{prior} visualizes the prior
distributions used in this package. Fast computing is enabled by parallel
programming.
}
\examples{
# Activate progress bar (optional)
\dontrun{progressr::handlers(global = TRUE)}
# Optimize
\donttest{
optimal_multiarm_binary( p0 = 0.6, 
  p11 =  0.3, p12 = 0.5, 
  n2min = 20, n2max = 100, stepn2 = 4,               # define optimization set for n2
  rrgomin = 0.7, rrgomax = 0.9, steprrgo = 0.05,     # define optimization set for RRgo
  alpha = 0.025, beta = 0.1,                         # drug development planning parameters
  c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,           # fixed/variable costs for phase II/III
  K = Inf, N = Inf, S = -Inf,                        # set constraints
  steps1 = 1,                                        # define lower boundary for "small"
  stepm1 = 0.95,                                     # "medium"
  stepl1 = 0.85,                                     # and "large" effect size categories
  b1 = 1000, b2 = 2000, b3 = 3000,                   # define expected benefits 
  strategy = 1, num_cl = 1)                          # number of cores for parallelized computing 
  }
}
\references{
IQWiG (2016). Allgemeine Methoden. Version 5.0, 10.07.2016, Technical Report. Available at \href{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}, assessed last 15.05.19.
}
