% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_bias_binary.R
\name{Epgo_bias_binary}
\alias{Epgo_bias_binary}
\alias{Epgo_binary_L2}
\alias{Epgo_binary_R2}
\title{Expected probability to go to phase III for bias adjustment programs with binary distributed outcomes}
\usage{
Epgo_binary_L2(RRgo, n2, Adj, p0, w, p11, p12, in1, in2, fixed)

Epgo_binary_R2(RRgo, n2, Adj, p0, w, p11, p12, in1, in2, fixed)
}
\arguments{
\item{RRgo}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be even number}

\item{Adj}{adjustment parameter}

\item{p0}{assumed true rate of control group}

\item{w}{weight for mixture prior distribution}

\item{p11}{assumed true rate of treatment group}

\item{p12}{assumed true rate of treatment group}

\item{in1}{amount of information for \code{p11} in terms of sample size}

\item{in2}{amount of information for \code{p12} in terms of sample size}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{p11} is used as fixed effect}
}
\value{
The output of the functions \code{Epgo_binary_L2} and \code{Epgo_binary_R2} is the expected number of participants in phase III with conservative decision rule and sample size calculation.
}
\description{
In the case we do not only want do discount for overoptimistic results in phase II when calculating the sample size in phase III,
but also when deciding whether to go to phase III or not the functions \code{Epgo_binary_L2} and \code{Epgo_binary_R2} are necessary.
The function \code{Epgo_binary_L2} uses an additive adjustment parameter (i.e. adjust the lower bound of the one-sided confidence interval),
the function \code{Epgo_binary_R2} uses a multiplicative adjustment parameter (i.e. use estimate with a retention factor)
}
\examples{
res <- Epgo_binary_L2(RRgo = 0.8, n2 = 50, Adj = 0,  p0 = 0.6,  w = 0.3,
                              p11 =  0.3, p12 = 0.5, in1 = 300, in2 = 600, 
                              fixed = FALSE)
          res <- Epgo_binary_R2(RRgo = 0.8, n2 = 50, Adj = 1,  p0 = 0.6,  w = 0.3,
                              p11 =  0.3, p12 = 0.5, in1 = 300, in2 = 600, 
                              fixed = FALSE)
}
\keyword{internal}
