% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{failureRate}
\alias{failureRate}
\title{Failure rates function}
\usage{
failureRate(
  x,
  k1 = 0L,
  k2,
  upstates,
  failure.rate = c("BMP", "RG"),
  output_file = NULL,
  plot = FALSE
)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{k1}{Start position (default value=0) :  a positive integer giving the start position along the sequence from which the failure rates of the DMM should be computed, such that \code{k1}<\code{k2}}

\item{k2}{End position :  a positive integer giving the end position along the sequence until which the failure rates of the DMM should be computed, such that \code{k2}>\code{k1}}

\item{upstates}{Character vector of the subspace working states among the state space vector such that upstates < s}

\item{failure.rate}{Default="BMP", then BMP-failure-rate is the method used to compute the failure rate. If \code{failure.rate}= "RG",
then RG-failure rate is the method used to compute the failure rate.}

\item{output_file}{(Optional) A file containing matrix of failure rates at each position (e.g, "C:/.../ER.txt")}

\item{plot}{\code{FALSE} (default); \code{TRUE} (display a figure plot of failure rates by position)}
}
\value{
A vector of length k + 1 giving the values of the BMP (or RG) -failure rate for the period \eqn{[0 \ldots k]}
}
\description{
Computation of two different definition of the failure rate : the BMP-failure rate and RG-failure rate.

As for BMP-failure rate, consider a system S starting to work at time \eqn{k = 0}. The BMP-failure rate at time \eqn{k \in N} is
the conditional probability that the failure of the system occurs at time \eqn{k}, given that the system has
worked until time \eqn{k - 1}. The BMP-failure rate denoted by \eqn{\lambda(k), k \in N} is usually considered for
continuous time systems.

The RG-failure rate is a discrete-time adapted failure-rate proposed by D. Roy and R. Gupta. Classification of discrete
lives. \emph{Microelectronics Reliability}, 32(10):1459–1473, 1992. The RG-failure rate is denoted by \eqn{r(k), k \in N}.
}
\details{
Consider a system (or a component) System whose possible states during its evolution in time are
\eqn{E = \{1 \ldots s \}}. Denote by \eqn{U = \{1 \ldots s_1 \}} the subset of operational states of the system (the upstates) and by \eqn{D =\{s_{1}+1 \ldots s \}} the subset of failure states (the down states), with 0 < s1 < s(obviously, \eqn{E = U \cup D and U \cap D = \emptyset, U \neq \emptyset, D \neq \emptyset}). One can think of the states of U as
different operating modes or performance levels of the system, whereas the states of D can be seen as failures of the systems with different modes.
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq",
 fit.method="sum")
k1 <- 1
k2 <- 200
upstates <- c("c","t")  # vector of working states
failureRate(dmm,k1,k2,upstates,failure.rate="BMP",plot=TRUE)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{roygup1992}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{reliability}
}
\author{
Alexandre Seiller
}
