% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic4.R
\name{logistic4_gradient}
\alias{logistic4_gradient}
\alias{logistic4_hessian}
\alias{logistic4_gradient_hessian}
\title{4-parameter logistic function gradient and Hessian}
\usage{
logistic4_gradient(x, theta)

logistic4_hessian(x, theta)

logistic4_gradient_hessian(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, delta, eta, phi)}.}
}
\value{
Gradient or Hessian evaluated at the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
4-parameter logistic function.
}
\details{
The 4-parameter logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = 1 / (1 + exp(-eta * (x - phi)))}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{theta = c(alpha, delta, eta, phi)} and \code{eta > 0}. When \code{delta} is
positive (negative) the curve is monotonically increasing (decreasing).
}
