% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{running}
\alias{running}
\title{List running targets.
\lifecycle{maturing}}
\usage{
running(
  path = NULL,
  search = NULL,
  cache = drake::drake_cache(path = path),
  verbose = 1L
)
}
\arguments{
\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{verbose}{Deprecated on 2019-09-11.}
}
\value{
A character vector of target names.
}
\description{
List the targets that either
(1) are currently being built during a call to \code{\link[=make]{make()}}, or
(2) if \code{\link[=make]{make()}} was interrupted, the targets that were running
at the time.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
running() # Everything should be done.
# nolint start
# Run make() in one R session...
# slow_plan <- drake_plan(x = Sys.sleep(2))
# make(slow_plan)
# and see the progress in another session.
# running()
# nolint end
}
})
}
}
\seealso{
\code{\link[=failed]{failed()}}, \code{\link[=make]{make()}}
}
