% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cached}
\alias{cached}
\title{List targets in the cache.
\lifecycle{maturing}}
\usage{
cached(
  ...,
  list = character(0),
  no_imported_objects = FALSE,
  path = NULL,
  search = NULL,
  cache = drake::drake_cache(path = path),
  verbose = NULL,
  namespace = NULL,
  jobs = 1,
  targets_only = TRUE
)
}
\arguments{
\item{...}{Deprecated. Do not use.
Objects to load from the cache, as names (unquoted)
or character strings (quoted). Similar to \code{...} in
\code{remove()}.}

\item{list}{Deprecated. Do not use.
Character vector naming objects to be loaded from the
cache. Similar to the \code{list} argument of \code{\link[=remove]{remove()}}.}

\item{no_imported_objects}{Logical, deprecated. Use
\code{targets_only} instead.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{verbose}{Deprecated on 2019-09-11.}

\item{namespace}{Character scalar, name of the storr namespace
to use for listing objects.}

\item{jobs}{Number of jobs/workers for parallel processing.}

\item{targets_only}{Logical. If \code{TRUE} just list the targets.
If \code{FALSE}, list files and imported objects too.}
}
\value{
Either a named logical indicating whether the given
targets or cached or a character vector listing all cached
items, depending on whether any targets are specified.
}
\description{
Tip: read/load a cached item with \code{\link[=readd]{readd()}}
or \code{\link[=loadd]{loadd()}}.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
if (requireNamespace("lubridate")) {
load_mtcars_example() # Load drake's canonical example.
make(my_plan) # Run the project, build all the targets.
cached()
cached(targets_only = FALSE)
}
}
})
}
}
\seealso{
\code{\link[=readd]{readd()}}, \code{\link[=loadd]{loadd()}},
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
