% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-read.R
\name{readd}
\alias{readd}
\alias{loadd}
\title{Read and return a drake target/import from the cache.}
\usage{
readd(target, character_only = FALSE, path = NULL, search = NULL,
  cache = drake::drake_cache(path = path, verbose = verbose),
  namespace = NULL, verbose = 1L, show_source = FALSE)

loadd(..., list = character(0), imported_only = NULL, path = NULL,
  search = NULL, cache = drake::drake_cache(path = path, verbose =
  verbose), namespace = NULL, envir = parent.frame(), jobs = 1,
  verbose = 1L, deps = FALSE, lazy = "eager", graph = NULL,
  replace = TRUE, show_source = FALSE, tidyselect = !deps,
  config = NULL)
}
\arguments{
\item{target}{If \code{character_only} is \code{TRUE}, then
\code{target} is a character string naming the object to read.
Otherwise, \code{target} is an unquoted symbol with the name of the
object.}

\item{character_only}{Logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link[=library]{library()}}).}

\item{path}{Path to a \code{drake} cache
(usually a hidden \code{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{namespace}{Optional character string,
name of the \code{storr} namespace to read from.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{show_source}{Logical, option to show the command
that produced the target or indicate that the object
was imported (using \code{\link[=show_source]{show_source()}}).}

\item{...}{Targets to load from the cache: as names (symbols) or
character strings. If the \code{tidyselect} package is installed,
you can also supply \code{dplyr}-style \code{tidyselect}
commands such as \code{starts_with()}, \code{ends_with()}, and \code{one_of()}.}

\item{list}{Character vector naming targets to be loaded from the
cache. Similar to the \code{list} argument of \code{\link[=remove]{remove()}}.}

\item{imported_only}{Logical, deprecated.}

\item{envir}{Environment to load objects into. Defaults to the
calling environment (current workspace).}

\item{jobs}{Number of parallel jobs for loading objects. On
non-Windows systems, the loading process for multiple objects
can be lightly parallelized via \code{parallel::mclapply()}.
just set jobs to be an integer greater than 1. On Windows,
\code{jobs} is automatically demoted to 1.}

\item{deps}{Logical, whether to load any cached
dependencies of the targets
instead of the targets themselves.

Important note:
\code{deps = TRUE} disables \code{tidyselect} functionality. For example,
\code{loadd(starts_with("model_"), config = config, deps = TRUE)}
does not work. For the selection mechanism to work,
the \code{model_*} targets to need to already be in the cache,
which is not always the case when you are debugging your projects.
To help \code{drake} understand what you mean,
you must name the targets \emph{explicitly} when \code{deps} is \code{TRUE}, e.g.
\code{loadd(model_A, model_B, config = config, deps = TRUE)}.}

\item{lazy}{Either a string or a logical. Choices:
\itemize{
\item \code{"eager"}: no lazy loading. The target is loaded right away
with \code{\link[=assign]{assign()}}.
\item \code{"promise"}: lazy loading with \code{\link[=delayedAssign]{delayedAssign()}}
\item \code{"bind"}: lazy loading with active bindings:
\code{bindr::populate_env()}.
\item \code{TRUE}: same as \code{"promise"}.
\item \code{FALSE}: same as \code{"eager"}.
}}

\item{graph}{Deprecated.}

\item{replace}{Logical. If \code{FALSE},
items already in your environment
will not be replaced.}

\item{tidyselect}{Logical, whether to enable
\code{tidyselect} expressions in \code{...} like
\code{starts_with("prefix")} and \code{ends_with("suffix")}.}

\item{config}{Optional \code{\link[=drake_config]{drake_config()}} object.
You should supply one if \code{deps} is \code{TRUE}.}
}
\value{
The cached value of the \code{target}.
}
\description{
\code{\link[=readd]{readd()}} returns an object from the cache,
and \code{\link[=loadd]{loadd()}} loads one or more objects from the cache
into your environment or session. These objects are usually
targets built by \code{\link[=make]{make()}}.
}
\details{
There are two uses for the
\code{\link[=loadd]{loadd()}} and \code{\link[=readd]{readd()}} functions:
\enumerate{
\item Exploring the results outside the \code{drake}/\code{make()} pipeline.
When you call \code{\link[=make]{make()}} to run your project,
\code{drake} puts the targets in a cache, usually a folder called \code{.drake}.
You may want to inspect the targets afterwards, possibly in an
interactive R session. However, the files in the \code{.drake} folder
are organized in a special format created by the
\href{https://github.com/richfitz/storr}{storr} package,
which is not exactly human-readable.
To retrieve a target for manual viewing, use \code{\link[=readd]{readd()}}.
To load one or more targets into your session, use \code{\link[=loadd]{loadd()}}.
\item In \code{knitr} / R Markdown reports.
You can borrow \code{drake} targets in your active code chunks
if you have the right calls to \code{\link[=loadd]{loadd()}} and \code{\link[=readd]{readd()}}.
These reports can either run outside the \code{drake} pipeline,
or better yet, as part of the pipeline itself.
If you call \code{knitr_in("your_report.Rmd")} inside a \code{\link[=drake_plan]{drake_plan()}}
command, then \code{\link[=make]{make()}} will scan \code{"your_report.Rmd"} for
calls to \code{loadd()} and \code{readd()} in active code chunks,
and then treat those loaded targets as dependencies.
That way, \code{\link[=make]{make()}} will automatically (re)run the report if those
dependencies change.
\item If you are using \code{make(memory_strategy = "none")}
or \code{make(memory_strategy = "unload")},
\code{\link[=loadd]{loadd()}} and \code{\link[=readd]{readd()}} can manually load dependencies
into memory for the target that is being built.
If you do this, you must carefully inspect \code{\link[=deps_target]{deps_target()}}
and \code{\link[=vis_drake_graph]{vis_drake_graph()}} before running \code{\link[=make]{make()}}
to be sure the dependency relationships among targets
are correct. If you do not wish to incur extra dependencies
with \code{\link[=loadd]{loadd()}} or \code{\link[=readd]{readd()}}, you will need to use \code{\link[=ignore]{ignore()}},
e.g. \code{drake_plan(x = 1, y = ignore(readd(x)))} or
\code{drake_plan(x = 1, y = readd(ignore("x"), character_only = TRUE))}.
Compare those plans to \code{drake_plan(x = 1, y = readd(x))}
and \code{drake_plan(x = 1, y = readd("x", character_only = TRUE))}
using \code{\link[=vis_drake_graph]{vis_drake_graph()}} and \code{\link[=deps_target]{deps_target()}}.
}
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
readd(reg1) # Return imported object 'reg1' from the cache.
readd(small) # Return targets 'small' from the cache.
readd("large", character_only = TRUE) # Return 'large' from the cache.
# For external files, only the fingerprint/hash is stored.
readd(file_store("report.md"), character_only = TRUE)
}
})
}
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the projects, build the targets.
config <- drake_config(my_plan)
loadd(small) # Load target 'small' into your workspace.
small
# For many targets, you can parallelize loadd()
# using the 'jobs' argument.
loadd(list = c("small", "large"), jobs = 2)
ls()
# Load the dependencies of the target, coef_regression2_small
loadd(coef_regression2_small, deps = TRUE, config = config)
ls()
# Load all the targets listed in the workflow plan
# of the previous `make()`.
# If you do not supply any target names, `loadd()` loads all the targets.
# Be sure your computer has enough memory.
loadd()
ls()
}
})
}
}
\seealso{
\code{\link[=cached]{cached()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}

\code{\link[=cached]{cached()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
