% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{get_cache}
\alias{get_cache}
\title{Get the drake cache, optionally searching up the file system.}
\usage{
get_cache(path = getwd(), search = TRUE, verbose = 1, force = FALSE,
  fetch_cache = NULL)
}
\arguments{
\item{path}{file path to the folder containing the cache.
Yes, this is the parent directory containing the cache,
not the cache itself, and it assumes the cache is in the
`.drake` folder. If you are looking for a different cache
with a known folder different from `.drake`, use
the \code{\link{this_cache}()} function.}

\item{search}{logical, whether to search back in the file system
for the cache.}

\item{verbose}{logical, whether to print the location of the cache}

\item{force}{logical, whether to load the cache
despite any back compatibility issues with the
running version of drake.}

\item{fetch_cache}{character vector containing lines of code.
The purpose of this code is to fetch the \code{storr} cache
with a command like \code{storr_rds()} or \code{storr_dbi()},
but customized. This feature is experimental.}
}
\value{
A drake/storr cache in a folder called \code{.drake/},
if available. \code{NULL} otherwise.
}
\description{
Only works if the cache
is in a folder called \code{.drake/}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
clean(destroy = TRUE)
# No cache is available.
get_cache() # NULL
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
x <- get_cache() # Now, there is a cache.
# List the objects readable from the cache with readd().
x$list() # Or x$list(namespace = x$default_namespace)
})
}
}
\seealso{
\code{\link{this_cache}}, \code{\link{new_cache}},
\code{\link{recover_cache}}, \code{\link{config}}
}
