% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan.R
\name{plan}
\alias{plan}
\title{Function \code{plan}}
\usage{
plan(..., list = character(0), file_targets = FALSE,
  strings_in_dots = c("filenames", "literals"))
}
\arguments{
\item{...}{commands named by the targets they generate.
Recall that drake uses single quotes to denote external files
and double-quoted strings as ordinary strings.
Use the \code{strings_in_dots} argument to control the
quoting in \code{...}.}

\item{list}{character vector of commands named
by the targets they generate.}

\item{file_targets}{logical. If \code{TRUE}, targets are single-quoted
to tell drake that these are external files that should be expected
as output in the next call to \code{\link{make}()}.}

\item{strings_in_dots}{character scalar. If \code{"filenames"},
all character strings in \code{...} will be treated as names of file
dependencies (single-quoted). If \code{"literals"}, all
character strings in \code{...} will be treated as ordinary
strings, not dependencies of any sort (double-quoted).
Because of R's automatic parsing/deparsing behavior,
strings in \code{...} cannot simply be left alone.}
}
\value{
data frame of targets and command
}
\description{
Turns a named collection of command/target pairs into
a workflow plan data frame for \code{\link{make}} and
\code{\link{check}}.
}
\details{
A workflow plan data frame is a data frame
with a \code{target} column and a \code{command} column.
Targets are the objects and files that drake generates,
and commands are the pieces of R code that produce them.

For file inputs and targets, drake uses single quotes.
Double quotes are reserved for ordinary strings.
The distinction is important because drake thinks about
how files, objects, targets, etc. depend on each other.
Quotes in the \code{list} argument are left alone,
but R messes with quotes when it parses the free-form
arguments in \code{...}, so use the \code{strings_in_dots}
argument to control the quoting in \code{...}.
}
\examples{
plan(small = simulate(5), large = simulate(50))
plan(list = c(x = "1 + 1", y = "sqrt(x)"))
plan(data = readRDS("my_data.rds"))
plan(my_file.rds = saveRDS(1+1, "my_file.rds"), file_targets = TRUE,
  strings_in_dots = "literals")
}
\seealso{
\code{link{check}}, \code{\link{make}},
}
