% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_htmltable.R
\name{dq_htmltable}
\alias{dq_htmltable}
\title{Create a HTML table containing the given list of elements}
\usage{
dq_htmltable(elements, id = NULL, align = "left")
}
\arguments{
\item{elements}{List of elements to show in the list, each element of the
list should be a row of the table.}

\item{id}{Optional, character specifying the elements id.}

\item{align}{Optional, character (vector) or list of characters showing the
alignment of the table or each column/cell, can be one of "left", "right"
or "center", defaults to "left", can be abbreviated.}
}
\value{
HTML table
}
\description{
Creates a HTML table containing the given list of elements.
Every element of the list should be a vector of the same length to ensure
correct design. The align parameter can be either a character, which will
result in all cells having the same alignment, a character vector showing
the alignment for every column or a list of character vectors specifying
the alignment of every cell.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    fluidRow(
      column(3, dq_htmltable(list(list("Description", icon("hashtag")),
                             list("Value", textInput("value", NULL)),
                             list("Result", textOutput("result")))),
                             offset = 2, style="background:#ff8f00"
      ),
      column(3, dq_htmltable(list(list("Left", "Center", "Right"),
                             list("Center", "Right", "Left")),
                             align = list(c("left", "center", "right"),
                             c("center", "right", "left"))),
                             offset = 1, style="background:#ff8f00"
      )
    )),
  server = function(input, output) {
    observeEvent(input$value, output$result <- renderText(input$value))
  }
)

}
}
\author{
richard.kunze
}
