% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/across.R
\name{across}
\alias{across}
\alias{if_any}
\alias{if_all}
\title{Apply a function (or functions) across multiple columns}
\usage{
across(.cols = everything(), .fns = NULL, ..., .names = NULL)

if_any(.cols, .fns = NULL, ..., .names = NULL)

if_all(.cols, .fns = NULL, ..., .names = NULL)
}
\arguments{
\item{.fns}{Functions to apply to each of the selected columns.
Possible values are:
\itemize{
\item \code{NULL}, to returns the columns untransformed.
\item A function, e.g. \code{mean}.
\item A purrr-style lambda, e.g. \code{~ mean(.x, na.rm = TRUE)}
\item A list of functions/lambdas, e.g.
\verb{list(mean = mean, n_miss = ~ sum(is.na(.x))}
}

Within these functions you can use \code{\link[=cur_column]{cur_column()}} and \code{\link[=cur_group]{cur_group()}}
to access the current column and grouping keys respectively.}

\item{...}{Additional arguments for the function calls in \code{.fns}.}

\item{.names}{A glue specification that describes how to name the output
columns. This can use \code{{.col}} to stand for the selected column name, and
\code{{.fn}} to stand for the name of the function being applied. The default
(\code{NULL}) is equivalent to \code{"{.col}"} for the single function case and
\code{"{.col}_{.fn}"} for the case where a list is used for \code{.fns}.}

\item{cols, .cols}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> Columns to transform.
Because \code{across()} is used within functions like \code{summarise()} and
\code{mutate()}, you can't select or compute upon grouping variables.}
}
\value{
\code{across()} returns a tibble with one column for each column in \code{.cols} and each function in \code{.fns}.

\code{if_any()} and \code{if_all()} return a logical vector.
}
\description{
\code{across()} makes it easy to apply the same transformation to multiple
columns, allowing you to use \code{\link[=select]{select()}} semantics inside in "data-masking"
functions like \code{\link[=summarise]{summarise()}} and \code{\link[=mutate]{mutate()}}. See \code{vignette("colwise")} for
more details.

\code{if_any()} and \code{if_all()} are used with to apply the same
predicate function to a selection of columns and combine the
results into a single logical vector.

\code{across()} supersedes the family of "scoped variants" like
\code{summarise_at()}, \code{summarise_if()}, and \code{summarise_all()}.
}
\examples{
# across() -----------------------------------------------------------------
# Different ways to select the same set of columns
# See <https://tidyselect.r-lib.org/articles/syntax.html> for details
iris \%>\%
  as_tibble() \%>\%
  mutate(across(c(Sepal.Length, Sepal.Width), round))
iris \%>\%
  as_tibble() \%>\%
  mutate(across(c(1, 2), round))
iris \%>\%
  as_tibble() \%>\%
  mutate(across(1:Sepal.Width, round))
iris \%>\%
  as_tibble() \%>\%
  mutate(across(where(is.double) & !c(Petal.Length, Petal.Width), round))

# A purrr-style formula
iris \%>\%
  group_by(Species) \%>\%
  summarise(across(starts_with("Sepal"), ~mean(.x, na.rm = TRUE)))

# A named list of functions
iris \%>\%
  group_by(Species) \%>\%
  summarise(across(starts_with("Sepal"), list(mean = mean, sd = sd)))

# Use the .names argument to control the output names
iris \%>\%
  group_by(Species) \%>\%
  summarise(across(starts_with("Sepal"), mean, .names = "mean_{.col}"))
iris \%>\%
  group_by(Species) \%>\%
  summarise(across(starts_with("Sepal"), list(mean = mean, sd = sd), .names = "{.col}.{.fn}"))

# When the list is not named, .fn is replaced by the function's position
iris \%>\%
  group_by(Species) \%>\%
  summarise(across(starts_with("Sepal"), list(mean, sd), .names = "{.col}.fn{.fn}"))

# if_any() and if_all() ----------------------------------------------------
iris \%>\%
  filter(if_any(ends_with("Width"), ~ . > 4))
iris \%>\%
  filter(if_all(ends_with("Width"), ~ . > 2))

}
\seealso{
\code{\link[=c_across]{c_across()}} for a function that returns a vector
}
