% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/manip.r
\name{summarise}
\alias{summarise}
\alias{summarise_}
\alias{summarize}
\alias{summarize_}
\title{Summarise multiple values to a single value.}
\usage{
summarise(.data, ...)

summarise_(.data, ..., .dots)

summarize(.data, ...)

summarize_(.data, ..., .dots)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link{tbl_df}}, \code{\link{tbl_dt}} and \code{\link{tbl_sql}}.}

\item{...}{Name-value pairs of summary functions like \code{\link{min}()},
\code{\link{mean}()}, \code{\link{max}()} etc.}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse")} for details.}
}
\value{
An object of the same class as \code{.data}. One grouping level will
  be dropped.

  Data frame row names are silently dropped. To preserve, convert to an
  explicit variable.
}
\description{
Summarise multiple values to a single value.
}
\section{Backend variations}{


Data frames are the only backend that supports creating a variable and
using it in the same summary. See examples for more details.
}
\examples{
summarise(mtcars, mean(disp))
summarise(group_by(mtcars, cyl), mean(disp))
summarise(group_by(mtcars, cyl), m = mean(disp), sd = sd(disp))

# With data frames, you can create and immediately use summaries
by_cyl <- mtcars \%>\% group_by(cyl)
by_cyl \%>\% summarise(a = n(), b = a + 1)

\dontrun{
# You can't with data tables or databases
by_cyl_dt <- mtcars \%>\% tbl_dt() \%>\% group_by(cyl)
by_cyl_dt \%>\% summarise(a = n(), b = a + 1)

by_cyl_db <- src_sqlite(":memory:", create = TRUE) \%>\%
  copy_to(mtcars) \%>\% group_by(cyl)
by_cyl_db \%>\% summarise(a = n(), b = a + 1)
}
}
\seealso{
Other single.table.verbs: \code{\link{arrange}},
  \code{\link{arrange_}}; \code{\link{filter}},
  \code{\link{filter_}}; \code{\link{mutate}},
  \code{\link{mutate_}}, \code{\link{transmute}},
  \code{\link{transmute_}}; \code{\link{rename}},
  \code{\link{rename_}}, \code{\link{select}},
  \code{\link{select_}}; \code{\link{slice}},
  \code{\link{slice_}}
}

