% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/climate_anom_dendro_season.R
\name{climate.anom.dendro.season}
\alias{climate.anom.dendro.season}
\title{Seasonal Data}
\usage{
climate.anom.dendro.season(climate.data, year1, year2, year.start, is.anomaly)
}
\arguments{
\item{climate.data}{This is a matrix, normally loaded into R in CSV form with the columns: year, jan, feb, mar,..,dec}

\item{year1}{is the start of the period used to calculate climate anomalies.}

\item{year2}{is the end of the period used to calculate climate anomalies.}

\item{year.start}{is the start date of the climate data,}

\item{is.anomaly}{accepts true or false. True will calculate the anomalies; departures from the mean from the period specified in year1 and year2}
}
\value{
Return a matrix of time series with col names season for the seasons including lagged seasons; "SON_2","DJF_2","MAM_2","JJA_2","SON_1","DJF_1","MAM_1", "JJA_1","SON","DJF","MAM","JJA";
}
\description{
Changes monthly climate data to seasonal climate data.
}
\details{
This is required to change the monthly data, such as the data used in this package, to the seasons; Sept-Oct-Nov, Dec-Jan-Feb, Mar-Apr-May, Jun-Jul-Aug.
}
\examples{
data(SOI)  # this is the Southern Oscillation Index data loaded with this package.
data(temperature) # this is the temperature data loaded with this package.
data(precipitation) # this is the precipitation data loaded with this package.
SOI.anom.season.data  <- climate.anom.dendro.season( SOI, 1933, 1992, 1876,
    is.anomaly="TRUE")
temp.anom.season.data	<- climate.anom.dendro.season( temperature, 1933, 1992, 1876,
   is.anomaly="TRUE")
prec.anom.season.data	<- climate.anom.dendro.season( precipitation, 1933, 1992, 1876,
   is.anomaly="TRUE")
}
\author{
Maryann Pirie
}

