% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{adpcr-class}
\alias{adpcr}
\alias{adpcr-class}
\title{Class \code{"adpcr"} - end-point array digital PCR experiments}
\description{
A class specifically designed to contain results from end-point array
digital PCR experiments. Data is represented as matrix, where each column
describes different experiment. Type of data in all columns is specified in
slot \code{"type"} and could be a number of molecules \code{"nm"}, a number
of positive droplets \code{"tnm"} (in this case whole experiment is
represented by one row), a cycle threshold of each well \code{"ct"} or
fluorescence values \code{"fluo"}.
}
\section{Slots}{
 \describe{ \item{list(".Data")}{\code{"matrix"} containing
data from array. See Description.}\item{list("n")}{Object of class
\code{"integer"} equal to the number of partitions in each
experiment.} \item{list("breaks")}{\code{"numeric"}
vector giving the number of intervals into which \code{.Data} should be
cut.} \item{list("type")}{Object of class
\code{"character"} defining type of data. Could be \code{"nm"} (number of
molecules per partition), \code{"tp"} (total number of positive wells in
panel), \code{"fluo"} (fluorescence) or \code{"ct"} (threshold
cycle).} }
}
\examples{
rand_array <- sim_adpcr(400, 1600, 100, pos_sums = FALSE, n_panels = 5)
one_rand_array <- extract_dpcr(rand_array, 1)
plot_panel(one_rand_array, 40, 40)
}
\author{
Michal Burdukiewicz.
}
\seealso{
Ploting and management: \code{\link{bind_dpcr}},
\code{\link{extract_dpcr}}, \code{\link{plot_panel}}.

Simulation: \code{\link{sim_adpcr}}.

Real-time array digital PCR: \code{\linkS4class{rtadpcr}}.

Droplet digital PCR: \code{\linkS4class{ddpcr}}.
}
\keyword{classes}

