rulelist : ( rule | _0_rulelist ) +  ;
whitespace : ;
comment : ';' ( WSP | VCHAR ) * CRLF  ;
hex_val : 'x' HEXDIG + ( _0_hex_val | _1_hex_val ) ?  ;
_0_hex_val : ( '.' HEXDIG + ) +  ;
_1_hex_val : '-' HEXDIG +  ;
alternation : concatenation ( c_wsp * '/' c_wsp * concatenation ) *  ;
concatenation : repetition ( c_wsp + repetition ) *  ;
c_nl : comment | CRLF  ;
CHAR : "[\x01-\x7f]"  ;
WSP : SP | HTAB  ;
repeat : _0_repeat | _1_repeat  ;
_0_repeat : DIGIT +  ;
_1_repeat : DIGIT * '*' DIGIT *  ;
char_val : DQUOTE ( "[ -!]" | "[#-~]" ) * DQUOTE  ;
prose_val : '<' ( "[ -=]" | "[?-~]" ) * '>'  ;
LF : "\x0a"  ;
group : '(' c_wsp * alternation c_wsp * ')'  ;
bin_val : 'b' BIT + ( _0_bin_val | _1_bin_val ) ?  ;
_0_bin_val : ( '.' BIT + ) +  ;
_1_bin_val : '-' BIT +  ;
HTAB : "\x09"  ;
dec_val : 'd' DIGIT + ( _0_dec_val | _1_dec_val ) ?  ;
_0_dec_val : ( '.' DIGIT + ) +  ;
_1_dec_val : '-' DIGIT +  ;
_0_rulelist : c_wsp * c_nl  ;
rulename : ALPHA ( ALPHA | DIGIT | '-' ) *  ;
BIT : '0' | '1'  ;
elements : alternation c_wsp *  ;
option : '[' c_wsp * alternation c_wsp * ']'  ;
LWSP : ( WSP | _0_LWSP ) *  ;
_0_LWSP : CRLF WSP  ;
OCTET : "[\x01-\xfe]"  ;
CRLF : CR LF ;
HEXDIG : DIGIT | 'A' | 'B' | 'C' | 'D' | 'E' | 'F'  ;
CR : "\x0d"  ;
defined_as : c_wsp * ( '=' | '=/' ) c_wsp *  ;
repetition : repeat ? element  ;
DIGIT : "[0-9]"  ;
SP : " "  ;
num_val : '%' ( bin_val | dec_val | hex_val )  ;
rule : rulename defined_as elements c_nl  ;
element : rulename | group | option | char_val | num_val | prose_val  ;
c_wsp : WSP | _0_c_wsp  ;
_0_c_wsp : c_nl WSP  ;
VCHAR : "[!-~]"  ;
ALPHA : "[A-Z]" | "[a-z]"  ;
DQUOTE : "\""  ;

