% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{testSC}
\alias{testSC}
\title{Performs SC (switch count) test on switch data}
\usage{
testSC(
  switches,
  dropzeros = TRUE,
  bylineage = FALSE,
  pseudocount = 0,
  from = NULL,
  to = NULL,
  permuteAll = FALSE,
  alternative = c("two.sided", "greater", "less")
)
}
\arguments{
\item{switches}{Data frame from findSwitches}

\item{dropzeros}{Drop switches with zero counts?}

\item{bylineage}{Perform test for each lineage individually?}

\item{pseudocount}{Pseudocount for P value calculations}

\item{from}{Include only switches from this state?}

\item{to}{Include only switches to this state?}

\item{permuteAll}{Permute among trees?}

\item{alternative}{Perform one-sided (\code{greater} or \code{less})
or \code{two.sided} test}
}
\value{
A list containing a \code{tibble} with mean SC statistics, and another 
with SC statistics per repetition.
}
\description{
\code{testSC} performs an SC test
}
\details{
Output data table columns:
RECON = SC for observed data
PERMUTE = SC for permuted data
DELTA = RECON - PERMUTE
PLT = p value for DELTA < 0
PGT = p value for DELTA < 0
\itemize{
  \item  \code{FROM}: State going from.
  \item  \code{TO}: State going to.
  \item  \code{RECON}: SC for observed data.
  \item  \code{PERMUTE}: SC for permuted data.
  \item  \code{DELTA}:  RECON - PERMUTE.
  \item  \code{PLT}: p value that DELTA < 0
  \item  \code{PGT}: p value that DELTA > 0
  \item  \code{STAT}: Statistic used (SC).
  \item  \code{REP}: Bootstrap repetition.
  \item  \code{REPS}: Total number of ootstrap repetition.
}
}
\examples{
\dontrun{
igphyml <- "~/apps/igphyml/src/igphyml"
data(ExampleAirr)
ExampleAirr$sample_id = sample(ExampleAirr$sample_id)
clones = formatClones(ExampleAirr, trait="sample_id")
btrees = findSwitches(clones[1:2], bootstraps=100, nproc=1,
   igphyml=igphyml, trait="sample_id", id="temp", dir="temp")
testSC(btrees$switches)
}
}
\seealso{
Uses output from \link{findSwitches}. Related to \link{testPS}
and \link{testSP}.
}
