% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Germlines.R
\name{readIMGT}
\alias{readIMGT}
\title{\code{readIMGT} read in IMGT database}
\usage{
readIMGT(dir, quiet = FALSE)
}
\arguments{
\item{dir}{directory containing Immcantation-formatted IMGT database}

\item{quiet}{print warnings?}
}
\value{
List of lists, leading to IMGT-gapped nucleotide sequences.
Structure of object is list[[organism]][[locus]][[segment]]
Organism refers to species (i.e. human, mouse)
locus refers to locus (e.g. IGH, IGK, TRA)
segment refers to gene segment caegory (V, D, or J)
}
\description{
Loads all reference germlines from an Immcantation-formatted IMGT database.
}
\details{
Input directory must be formatted to Immcantation standard.
See https://changeo.readthedocs.io/en/stable/examples/igblast.html for example
of how to download.
}
\examples{
# vdj_dir contains a minimal example of reference germlines 
# (IGHV3-11*05, IGHD3-10*01 and IGHJ5*02)
# which are the gene assignments for ExamapleDb[1,]
vdj_dir <- system.file("extdata", "germlines", "imgt", "human", "vdj", package="dowser")
imgt <- readIMGT(vdj_dir)
}
