% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secret_weapon.R
\name{secret_weapon}
\alias{secret_weapon}
\title{Generate a 'Secret Weapon' Plot of Regression Results from Multiple Models}
\usage{
secret_weapon(x, var = NULL, ci = 0.95, margins = FALSE, by_2sd = FALSE, ...)
}
\arguments{
\item{x}{Either a tidy data frame including results from multiple models (see 'Details') or a list of model objects that can be tidied with \code{\link[broomExtra]{tidy_parameters}}}

\item{var}{The predictor whose results are to be shown in the 'secret weapon' plot}

\item{ci}{A number indicating the level of confidence intervals; the default is .95.}

\item{margins}{A logical value indicating whether presenting the average marginal effects of the estimates. See the Details for more information.}

\item{by_2sd}{When x is a list of model objects, should the coefficients for predictors that are not binary be rescaled by twice the standard deviation of these variables in the dataset analyzed, per Gelman (2008)?  Defaults to \code{TRUE}.  Note that when x is a tidy data frame, one can use \code{\link[dotwhisker]{by_2sd}} to rescale similarly.}

\item{\dots}{Arguments to pass to \code{\link[dotwhisker]{dwplot}}.}
}
\value{
The function returns a \code{ggplot} object.
}
\description{
\code{secret_weapon} is a function for plotting regression results of multiple models as a 'secret weapon' plot
}
\details{
Andrew Gelman has coined the term \href{https://statmodeling.stat.columbia.edu/2005/03/07/the_secret_weap/}{"the secret weapon"} for dot-and-whisker plots that compare the estimated coefficients for a single predictor across many models or datasets.
\code{secret_weapon} takes a tidy data frame of regression results or a list of model objects and generates a dot-and-whisker plot of the results of a single variable across the multiple models.

Tidy data frames to be plotted should include the variables \code{term} (names of predictors), \code{estimate} (corresponding estimates of coefficients or other quantities of interest), \code{std.error} (corresponding standard errors), and \code{model} (identifying the corresponding model).
In place of \code{std.error} one may substitute \code{lb} (the lower bounds of the confidence intervals of each estimate) and \code{ub} (the corresponding upper bounds).

Alternately, \code{secret_weapon} accepts as input a list of model objects that can be tidied by \code{\link[broomExtra]{tidy_parameters}}.
}
\examples{

library(dplyr)
library(broomExtra)

# Estimate models across many samples, put results in a tidy data frame
by_clarity <- diamonds \%>\% group_by(clarity) \%>\%
 do(tidy(lm(price ~ carat + cut + color, data = .))) \%>\%
 ungroup \%>\% rename(model = clarity)

# Generate a 'secret weapon' plot of the results of diamond size
secret_weapon(by_clarity, "carat")


}
