% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{dodgr_paths}
\alias{dodgr_paths}
\title{dodgr_paths}
\usage{
dodgr_paths(
  graph,
  from,
  to,
  vertices = TRUE,
  pairwise = FALSE,
  heap = "BHeap",
  quiet = TRUE
)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph (see Details)}

\item{from}{Vector or matrix of points \strong{from} which route paths are to
be calculated (see Details)}

\item{to}{Vector or matrix of points \strong{to} which route paths are to be
calculated (see Details)}

\item{vertices}{If \code{TRUE}, return lists of lists of vertices for each
path, otherwise return corresponding lists of edge numbers from \code{graph}.}

\item{pairwise}{If \code{TRUE}, calculate paths only between the ordered
pairs of \code{from} and \code{to}. In this case, each of these must be the
same length, and the output will contain paths the i-th members of each, and
thus also be of that length.}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
\code{Radix}, Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}

\item{quiet}{If \code{FALSE}, display progress messages on screen.}
}
\value{
List of list of paths tracing all connections between nodes such that
if \code{x <- dodgr_paths (graph, from, to)}, then the path between
\code{from[i]} and \code{to[j]} is \code{x [[i]] [[j]]}.
}
\description{
Calculate lists of pair-wise shortest paths between points.
}
\note{
\code{graph} must minimally contain four columns of \code{from},
\code{to}, \code{dist}. If an additional column named \code{weight} or
\code{wt} is present, shortest paths are calculated according to values
specified in that column; otherwise according to \code{dist} values. Either
way, final distances between \code{from} and \code{to} points are calculated
according to values of \code{dist}. That is, paths between any pair of points
will be calculated according to the minimal total sum of \code{weight}
values (if present), while reported distances will be total sums of
\code{dist} values.

The \code{from} and \code{to} columns of \code{graph} may be either single
columns of numeric or character values specifying the numbers or names of
graph vertices, or combinations to two columns specifying geographical
(longitude and latitude) coordinates. In the latter case, almost any sensible
combination of names will be accepted (for example, \verb{fromx, fromy},
\verb{from_x, from_y}, or \verb{fr_lat, fr_lon}.)

\code{from} and \code{to} values can be either two-column matrices of
equivalent of longitude and latitude coordinates, or else single columns
precisely matching node numbers or names given in \code{graph$from} or
\code{graph$to}. If \code{to} is missing, pairwise distances are calculated
between all points specified in \code{from}. If neither \code{from} nor
\code{to} are specified, pairwise distances are calculated between all nodes
in \code{graph}.
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 100)
to <- sample (graph$to_id, size = 50)
dp <- dodgr_paths (graph, from = from, to = to)
# dp is a list with 100 items, and each of those 100 items has 30 items, each
# of which is a single path listing all vertiex IDs as taken from `graph`.

# it is also possible to calculate paths between pairwise start and end
# points
from <- sample (graph$from_id, size = 5)
to <- sample (graph$to_id, size = 5)
dp <- dodgr_paths (graph, from = from, to = to, pairwise = TRUE)
# dp is a list of 5 items, each of which just has a single path between each
# pairwise from and to point.
}
\seealso{
Other distances: 
\code{\link{dodgr_distances}()},
\code{\link{dodgr_dists_categorical}()},
\code{\link{dodgr_dists}()},
\code{\link{dodgr_flows_aggregate}()},
\code{\link{dodgr_flows_disperse}()},
\code{\link{dodgr_flows_si}()},
\code{\link{dodgr_isochrones}()},
\code{\link{dodgr_isodists}()},
\code{\link{dodgr_isoverts}()},
\code{\link{dodgr_times}()}
}
\concept{distances}
