% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streetnet-fns.R
\name{weight_streetnet}
\alias{weight_streetnet}
\title{weight_streetnet}
\usage{
weight_streetnet(sf_lines, wt_profile = "bicycle", type_col = "highway",
  id_col = "osm_id")
}
\arguments{
\item{sf_lines}{A street network represented as \code{sf} \code{LINESTRING}
objects, typically extracted with \code{get_streetnet}}

\item{wt_profile}{Name of weighting profile, or vector of values with names
corresponding to names in \code{type_col}}

\item{type_col}{Specify column of the \code{sf} \code{data.frame} object
which designates different types of highways to be used for weighting
(default works with \code{osmdata} objects).}

\item{id_col}{Specify column of the code{sf} \code{data.frame} object which
provides unique identifiers for each highway (default works with
\code{osmdata} objects).}
}
\value{
A \code{data.frame} of edges representing the street network, along
with a column of graph component numbers.
}
\description{
Weight (or re-weight) an \code{sf}-formatted OSM street network according to
a named routino profile, selected from (foot, horse, wheelchair, bicycle,
moped, motorcycle, motorcar, goods, hgv, psv).
}
\examples{
# hampi is included with package as an 'osmdata' sf-formatted street network
net <- weight_streetnet (hampi)
class(net) # data.frame
dim(net) # 6096  11; 6096 streets
# os_roads_bristol is also included as an sf data.frame, but in a different
# format requiring identification of columns and specification of custom
# weighting scheme.
colnm <- "formOfWay"
wts <- c (0.1, 0.2, 0.8, 1)
names (wts) <- unique (os_roads_bristol [[colnm]])
net <- weight_streetnet (os_roads_bristol, wt_profile = wts,
                         type_col = colnm, id_col = "identifier")
dim (net) # 406 11; 406 streets
}
