# This example demonstrates a way to plot data that is
# computing by the workers.
suppressMessages(library(doMPI))

# Create and register an MPI cluster
nworkers <- 4
cl <- startMPIcluster(nworkers)
comm <- cl$comm  # get communicator number
registerDoMPI(cl)

# Force an interactive graphics device
cap <- capabilities()
if (cap['aqua']) quartz() else if (cap['X11']) X11() else windows()

# Create a plot with no points
plot(integer(0), integer(0),
     main='Random points generated by doMPI workers',
     xlab='X', ylab='Y', xlim=c(1,100), ylim=c(1,100))
legend('topright', sprintf('worker %d', 1:nworkers), pch=1:nworkers)

# Define a .combine function that plots points
plotpoint <- function(x, p) {
  do.call('points', p)
  x
}

# Return random points for the master to plot
foreach(i=icount(100), .combine='plotpoint',
        .init=NULL, .inorder=FALSE) %dopar% {
  Sys.sleep(abs(rnorm(1, mean=3)))
  list(x=sample(100,1), y=sample(80,1), pch=mpi.comm.rank(comm))
}

text(50, 90, 'Finished')
Sys.sleep(10)

# Shutdown the cluster and quit
closeCluster(cl)
mpi.quit()
