% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIclust_mpool.R
\name{MIclust_mpool}
\alias{MIclust_mpool}
\title{\code{MultiCons} wrapper for imputed datasets}
\usage{
MIclust_mpool(list.part, comb.cons, mcons.JAC.sel = 0, plot.MIclust = FALSE)
}
\arguments{
\item{list.part}{list of partitions, where one element of the list
corresponds to the clustering results for one imputed dataset. If more than
one clustering algorithm were used, each element if the list is a
dataframe, as obtained by \code{partition_generation()}.}

\item{comb.cons}{Boolean, use \code{TRUE} to perform an additional consensus
from all partitions (ie. one consensus per clustering algorithm used, plus
one consensus of all partitions: mixing all clustering algorithms used).
This parameter is forced to \code{FALSE} if \code{length(algo)<2}.}

\item{mcons.JAC.sel}{Numeric (in (0,1)) passed to internal function
\code{my_jack()}. Minimum \code{Jaccard index} value between partitions to
keep them for the consensus.}

\item{plot.MIclust}{Boolean, should \code{MultiCons()} tree be plotted?}
}
\value{
a data frame with \code{ncol()} = number of algorithms (+1 if
\code{comb.cons == T}), containing the consensus partitions.
}
\description{
Performs \code{MultiCons()} from a list of partitions
}
\keyword{internal}
