% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restrict_env.R
\name{restrict_fun}
\alias{restrict_fun}
\alias{restrict_fun_sub}
\alias{restrict_fun_env}
\alias{get_restrictions}
\alias{get_fun}
\title{restrict}
\usage{
restrict_fun(fun, args, method = "env")

restrict_fun_sub(fun, args, envir = parent.frame())

restrict_fun_env(fun, args)

get_restrictions(object)

get_fun(object)
}
\arguments{
\item{fun}{Function to be restricted}

\item{args}{List of the form name=value}

\item{method}{Either "env" (for environment; the default, using an
auxillary argument for storing restricted values) or "sub" (for
substitute; based on substituting fixed values into the
function).}

\item{envir}{Environment}

\item{object}{An object from restrict_fun (a scaffold object).}
}
\value{
A new function: The input function `fun` but with certain
    arguments fixed at specific values.
}
\description{
Restrict a functions domain by fixing certain
    arguments of a function call.
}
\details{
`restrict_fun` is a wrapper for calling `restrict_fun_env`
    (default) or `restrict_fun_sub`.
}
\examples{

f1  <- function(x, y){x + y}
f1_ <- restrict_fun(f1, list(y=10))
f1_
f1_(x=1)
get_restrictions(f1_)
get_fun(f1_)

f2 <- function(x){
  x <- x + 2
  x
}
f2_ <- restrict_fun(f2, list(x=1)) 
f2_()

# Notice that this is absurd, because arguments are modified in the
# body
restrict_fun(f2, list(x=10), method="sub")

# A safe(r) alternative is:
f3 <- function(x){
  x_ <- x + 2
  x_
}
restrict_fun(f3, list(x=10), method="sub")

rnorm10 <- restrict_fun(rnorm, list(n=10)) 
rnorm(10)
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk} based on code
  adapted from the curry package.
}
