% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{filter_pathways}
\alias{filter_pathways}
\title{Remove pathways with non-significant DC scores.}
\usage{
filter_pathways(x, alpha_pathway = NULL, monotonized = FALSE)
}
\arguments{
\item{x}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{alpha_pathway}{Threshold for pathway p-values to determine significance.
If NULL, defaults to 0.05 or the minimum possible threshold (based on the
number of permutatiosn that were run).}

\item{monotonized}{If TRUE, monotonized p-values are used.}
}
\value{
A 'dnapath_list' object containing only those pathways with differential
connectivity p-values below \code{alpha}.
}
\description{
Remove pathways with non-significant DC scores.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   groups = meso$groups, n_perm = 10)
results_sig <- filter_pathways(results)
}
