% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summarize_pathways}
\alias{summarize_pathways}
\title{Summarize the differential connectivity of pathways.}
\usage{
summarize_pathways(x, alpha_pathway = NULL, alpha_gene = NULL,
  monotonized = FALSE)
}
\arguments{
\item{x}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{alpha_pathway}{Threshold for p-values of pathway DC scores.
If NULL (or 1), results for all pathways are shown.}

\item{alpha_gene}{Threshold for p-values of gene DC scores. Used to determine
the number of genes that are differentially connected within each pathway.
If NULL,
defaults to 0.05 or the minimum possible threshold (based on the
number of permutatiosn that were run).}

\item{monotonized}{If TRUE, monotonized p-values are used.}
}
\value{
A tibble summarizing the differential connectivity of genes in
the pathway.
}
\description{
Summarize the differential connectivity of pathways.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   groups = meso$groups, n_perm = 10)
summarize_pathways(results)
}
\seealso{
\code{\link{summarize_genes}}, \code{\link{summarize_edges}}
}
