% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_sql.R
\name{dm_sql}
\alias{dm_sql}
\alias{dm_ddl_pre}
\alias{dm_dml_load}
\alias{dm_ddl_post}
\title{Create \emph{DDL} and \emph{DML} scripts for a \code{dm} a and database connection}
\usage{
dm_sql(dm, dest, table_names = NULL, temporary = TRUE)

dm_ddl_pre(dm, dest, table_names = NULL, temporary = TRUE)

dm_dml_load(dm, dest, table_names = NULL, temporary = TRUE)

dm_ddl_post(dm, dest, table_names = NULL, temporary = TRUE)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{dest}{Connection to database.}

\item{table_names}{A named character vector or named vector of \link[DBI:Id]{DBI::Id},
\link[DBI:SQL]{DBI::SQL} or dbplyr objects created with \code{\link[dbplyr:ident]{dbplyr::ident()}}, \code{\link[dbplyr:in_schema]{dbplyr::in_schema()}}
or \code{\link[dbplyr:in_schema]{dbplyr::in_catalog()}},
with one unique element for each table in \code{dm}.
The default, \code{NULL}, means to use the original table names.}

\item{temporary}{Should the tables be marked as \emph{temporary}? Defaults to \code{TRUE}.}
}
\value{
Nested list of SQL statements.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Generate SQL scripts to create tables, load data and set constraints, keys and indices.
This function powers \code{\link[=copy_dm_to]{copy_dm_to()}} and is useful if you need more control
over the process of copying a \code{dm} to a database.
}
\details{
\itemize{
\item{ \code{dm_ddl_pre()} generates \verb{CREATE TABLE} statements (including \verb{PRIMARY KEY} definition). }
\item{ \code{dm_dml_load()} generates \verb{INSERT INTO} statements. }
\item{ \code{dm_ddl_post()} generates scripts for \verb{FOREIGN KEY}, \verb{UNIQUE KEY} and \code{INDEX}. }
\item{ \code{dm_sql()} calls all three above and returns a complete set of scripts. }
}
}
\examples{
\dontshow{if (rlang::is_installed(c("RSQLite", "dbplyr"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- DBI::dbConnect(RSQLite::SQLite())
dm <- dm_nycflights13()
s <- dm_sql(dm, con)
s
DBI::dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
