% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign-keys.R
\name{dm_get_all_fks}
\alias{dm_get_all_fks}
\title{Get foreign key constraints}
\usage{
dm_get_all_fks(dm, parent_table = NULL, ...)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{parent_table}{One or more table names, unquoted,
to return foreign key information for.
If given, foreign keys are returned in that order.
The default \code{NULL} returns information for all tables.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A tibble with the following columns:
\describe{
\item{\code{child_table}}{child table,}
\item{\code{child_fk_cols}}{foreign key column(s) in child table as list of character vectors,}
\item{\code{parent_table}}{parent table,}
\item{\code{parent_key_cols}}{key column(s) in parent table as list of character vectors.}
\item{\code{on_delete}}{behavior on deletion of rows in the parent table.}
}
}
\description{
Get a summary of all foreign key relations in a \code{\link{dm}}.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_get_all_fks()
\dontshow{\}) # examplesIf}
}
\seealso{
Other foreign key functions: 
\code{\link{dm_add_fk}()},
\code{\link{dm_enum_fk_candidates}()},
\code{\link{dm_rm_fk}()}
}
\concept{foreign key functions}
