% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_unnest_tbl.R
\name{dm_unnest_tbl}
\alias{dm_unnest_tbl}
\title{Unnest columns from a wrapped table}
\usage{
dm_unnest_tbl(dm, parent_table, col, ptype)
}
\arguments{
\item{dm}{A dm.}

\item{parent_table}{A table in the dm with nested columns.}

\item{col}{The column to unnest (unquoted).}

\item{ptype}{A dm, only used to query names of primary and foreign keys.}
}
\value{
A dm.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{dm_unnest_tbl()} target a specific column to unnest
from the given table in a given dm.
A ptype or a set of keys should be given, not both.
}
\details{
\code{\link[=dm_nest_tbl]{dm_nest_tbl()}} is an inverse operation to \code{dm_unnest_tbl()}
if differences in row and column order are ignored.
The opposite is true if referential constraints between both tables
are satisfied.
}
\examples{
airlines_wrapped <-
  dm_nycflights13() \%>\%
  dm_wrap_tbl(airlines)

# The ptype is required for reconstruction.
# It can be an empty dm, only primary and foreign keys are considered.
ptype <- dm_ptype(dm_nycflights13())

airlines_wrapped \%>\%
  dm_unnest_tbl(airlines, flights, ptype)
}
\seealso{
\code{\link[=dm_unwrap_tbl]{dm_unwrap_tbl()}}, \code{\link[=dm_unpack_tbl]{dm_unpack_tbl()}},
\code{\link[=dm_nest_tbl]{dm_nest_tbl()}}, \code{\link[=dm_pack_tbl]{dm_pack_tbl()}}, \code{\link[=dm_wrap_tbl]{dm_wrap_tbl()}},
\code{\link[=dm_examine_constraints]{dm_examine_constraints()}}, \code{\link[=dm_examine_cardinalities]{dm_examine_cardinalities()}},
\code{\link[=dm_ptype]{dm_ptype()}}.
}
