% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{sql_schema_drop}
\alias{sql_schema_drop}
\title{Remove a schema from a database}
\usage{
sql_schema_drop(dest, schema, force = FALSE, ...)
}
\arguments{
\item{dest}{An object of class \code{"src"} or \code{"DBIConnection"}.}

\item{schema}{Class \code{character} or \code{SQL} (cf. Details), name of the schema}

\item{force}{Boolean, default \code{FALSE}. Set to \code{TRUE} to drop a schema and
all objects it contains at once. Currently only supported for Postgres.}

\item{...}{Passed on to the individual methods.}
}
\value{
\code{NULL} invisibly.
}
\description{
\code{sql_schema_drop()} deletes a schema from the database.
For certain DBMS it is possible to force the removal of a non-empty schema, see below.
}
\details{
Methods are not available for all DBMS.

An error is thrown if no schema of that name exists.

The argument \code{schema} (and \code{dbname} for MSSQL) can be provided as \code{SQL} objects.
Keep in mind, that in this case it is assumed that they are already correctly quoted as identifiers.

Additional arguments are:
\itemize{
\item \code{dbname}: supported for MSSQL. Remove a schema from a different
database on the connected MSSQL-server; default: database addressed by \code{dest}.
}
}
\seealso{
Other schema handling functions: 
\code{\link{sql_schema_create}()},
\code{\link{sql_schema_exists}()},
\code{\link{sql_schema_list}()}
}
\concept{schema handling functions}
