% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-dm.R
\name{dm_draw}
\alias{dm_draw}
\alias{dm_set_colors}
\alias{dm_get_colors}
\alias{dm_get_available_colors}
\title{Draw a diagram of the data model}
\usage{
dm_draw(
  dm,
  rankdir = "LR",
  col_attr = "column",
  view_type = "keys_only",
  columnArrows = TRUE,
  graph_attrs = "",
  node_attrs = "",
  edge_attrs = "",
  focus = NULL,
  graph_name = "Data Model"
)

dm_set_colors(dm, ...)

dm_get_colors(dm)

dm_get_available_colors()
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{rankdir}{Graph attribute for direction (e.g., 'BT' = bottom --> top).}

\item{col_attr}{Column atributes to display.
By default only the column name (\code{"column"}) is displayed.}

\item{view_type}{Can be "keys_only" (default), "all" or "title_only".
It defines the level of details for rendering tables
(only primary and foreign keys, all columns, or no columns).}

\item{columnArrows}{Edges from columns to columns (default: \code{TRUE}).}

\item{graph_attrs}{Additional graph attributes.}

\item{node_attrs}{Additional node attributes.}

\item{edge_attrs}{Additional edge attributes.}

\item{focus}{A list of parameters for rendering (table filter).}

\item{graph_name}{The name of the graph.}

\item{...}{Colors to set in the form \code{color = table}.
Allowed colors are all hex coded colors (quoted) and the color names from \code{dm_get_available_colors()}.
\code{tidyselect} is supported, see \code{\link[dplyr:select]{dplyr::select()}} for details on the semantics.}
}
\value{
For \code{dm_draw()}: returns an object of class \code{grViz} (see also \code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}), which,
when printed, produces the output seen in the viewer as a side effect.

For \code{dm_set_colors()}: the updated data model.

For \code{dm_get_colors()}, a two-column tibble with one row per table.

For \code{dm_get_available_colors()}, a vector with the available colors.
}
\description{
\code{dm_draw()} uses \pkg{DiagrammeR} to draw diagrams.

\code{dm_set_colors()} allows to define the colors that will be used to display the tables of the data model.
The colors can either be either specified with hex color codes or using the names of the built-in R colors.
An overview of the colors corresponding to the standard color names can be found at
the bottom of
\url{http://rpubs.com/krlmlr/colors}.

\code{dm_get_colors()} returns the colors defined for a data model.

\code{dm_get_available_colors()} returns an overview of the names of the available colors
These are the standard colors also returned by \code{grDevices::colors()} plus a default
table color with the name "default".
}
\examples{
dm_draw(dm_nycflights13())
dm_draw(dm_nycflights13(cycle = TRUE))
dm_get_available_colors()
dm_get_colors(dm_nycflights13())

dm_nycflights13(color = FALSE) \%>\%
  dm_set_colors(
    darkblue = starts_with("air"),
    "#5986C4" = flights
  ) \%>\%
  dm_draw()

# Splicing is supported:
nyc_cols <- dm_get_colors(dm_nycflights13())
nyc_cols

dm_nycflights13(color = FALSE) \%>\%
  dm_set_colors(!!!nyc_cols) \%>\%
  dm_draw()
}
