#' retrieve_node
#'
#' Returns metadata associated with an existing DKAN Node ID.
#'
#' @param nid character: DKAN node ID
#' @param url character: The DKAN site URL
#' @param credentials Optional list parameter. Default values are Cookie and Token generated by dkan_setup()
#' @param as character: Output format. Options are: 'json' or 'list'
#' @param ... Other optional parameters passed to the underlying GET request
#'
#' @return dkan_node object
#' @export
#'
#' @examples
#' \dontrun{
#' retrieve_node(nid = 1, url = "http://demo.getdkan.com")
#' }
retrieve_node <- function(nid,
                          url = get_url(),
                          credentials = list(cookie = dkanr::get_cookie(),
                                             token = dkanr::get_token()),
                          as = "json", ...) {
  # CHECK: input validity
  assertthat::assert_that(
    !is.null(nid),
    msg = "The Node ID (nid) argument must be specified"
  )
  res <- dkan_GET(url = url, nid = nid, credentials = credentials, ...)
  switch(as, json = res, list = as_dk(jsl(res), "dkan_node"))
}
