context("testing overlap functions")

library(testthat)
library(diyar)
library(dplyr)
library(lubridate)

test_that("test overlap functions", {

  expect_equal(across(number_line(-100, 100), number_line(50, 200)), TRUE)
  expect_equal(across(number_line(-100, 50), number_line(50, 200)), FALSE)
  expect_equal(across(number_line(-100, 50), number_line(-100, 200)), FALSE)
  expect_equal(chain(number_line(-100, 50), number_line(50, 200)), TRUE)
  expect_equal(chain(number_line(-100, 50), number_line(200, 50)), FALSE)
  expect_equal(aligns_start(number_line(-100, 50), number_line(-100, 200)), TRUE)
  expect_equal(aligns_start(number_line(-100, 50), number_line(200, -100)), FALSE)
  expect_equal(aligns_start(number_line(-100, -100), number_line(200, -100)), FALSE)

  expect_equal(chain(number_line(-100, -100), number_line(200, -100)), TRUE)
  expect_equal(aligns_end(number_line(-1121, -100), number_line(200, -100)), TRUE)
  expect_equal(inbetween(number_line(-1121, 1100), number_line(-100, 100)), TRUE)
  expect_equal(inbetween(number_line(-1121, 1100), number_line(-100, 1100)), FALSE)

  expect_equal(overlap(number_line(-100, -100), number_line(200, -100)), TRUE)
  expect_equal(overlap(number_line(-100, 50), number_line(200, -100)), TRUE)

})


test_that("test overlap method function", {
  expect_equal(overlap_method(number_line(-100, 100), number_line(50, 200)), "across")
  expect_equal(overlap_method(number_line(-100, 50), number_line(50, 200)), "chain")
  expect_equal(overlap_method(number_line(-100, 50), number_line(-100, 200)), "aligns_start")
  expect_equal(overlap_method(number_line(-100, 50), number_line(200, 50)), "aligns_end")
  expect_equal(overlap_method(number_line(-100, 50), number_line(200, -100)), "chain,inbetween")
  expect_equal(overlap_method(number_line(-100, -100), number_line(200, -100)), "chain,aligns_end")
  expect_equal(overlap_method(number_line(-100, -100), number_line(200, -100)), "chain,aligns_end")
  expect_equal(overlap_method(number_line(-1121, -100), number_line(200, -100)), "aligns_end")
  expect_equal(overlap_method(number_line(-1121, 1100), number_line(-100, 100)), "inbetween")
  expect_equal(overlap_method(number_line(-1121, 1100), number_line(-100, 1100)), "aligns_end")
})

test_that("test that error and warning messages are returned correctly", {
  expect_error(overlap(1, number_line(50, 200)), "'x' is not a number_line object")
  expect_error(overlap(number_line(50, 200), 1), "'y' is not a number_line object")

  expect_error(across(1, number_line(50, 200)), "'x' is not a number_line object")
  expect_error(across(number_line(50, 200), 1), "'y' is not a number_line object")

  expect_error(inbetween(1, number_line(50, 200)), "'x' is not a number_line object")
  expect_error(inbetween(number_line(50, 200), 1), "'y' is not a number_line object")

  expect_error(aligns_start(1, number_line(50, 200)), "'x' is not a number_line object")
  expect_error(aligns_start(number_line(50, 200), 1), "'y' is not a number_line object")

  expect_error(aligns_end(1, number_line(50, 200)), "'x' is not a number_line object")
  expect_error(aligns_end(number_line(50, 200), 1), "'y' is not a number_line object")

  expect_error(chain(1, number_line(50, 200)), "'x' is not a number_line object")
  expect_error(chain(number_line(50, 200), 1), "'y' is not a number_line object")

  expect_error(overlap_method(1, number_line(50, 200)), "'x' is not a number_line object")
  expect_error(overlap_method(number_line(50, 200), 1), "'y' is not a number_line object")

  expect_error(overlap(number_line(-100, 100), number_line(50, 200), "overlaping"), "`method` must be either 'across','chain','aligns_start','aligns_end' or 'inbetween'")
  expect_error(overlap(number_line(-100, 100), number_line(50, 200), 2), "'method' must be a character object")
})


test_that("test compress function", {
  expect_equal(compress_number_line(c(number_line(1, 20), number_line(5, 7))), number_line(1,20))
  expect_equal(compress_number_line(c(number_line(20, 1), number_line(5, 7))), number_line(1,20))
  expect_equal(compress_number_line(c(number_line(2, 5), number_line(3, 3), number_line(6, 7))), c(number_line(2,5, id=1, gid =1), number_line(6,7, id=3, gid =3)))

  #warnings and errors
  expect_error(compress_number_line(c(number_line(1, 20), number_line(5, 7), number_line(1,20)), method = 2), "'method' must be a character object")
  expect_error(compress_number_line(c(number_line(1, 20), number_line(5, 7), number_line(1,20)), collapse = 2), "'collapse' and 'deduplicate' must be TRUE or FALSE")
  expect_error(compress_number_line(c(number_line(1, 20), number_line(5, 7), number_line(1,20)), collapse = rep(TRUE,4)), "length of 'collapse' must be 1 or the same as 'x'")
  expect_error(compress_number_line(c(number_line(1, 20), number_line(5, 7), number_line(1,20)), deduplicate ="2"), "'collapse' and 'deduplicate' must be TRUE or FALSE")
  expect_error(compress_number_line(c(number_line(1, 20), number_line(5, 7), number_line(1,20)), method = "crossing"), "`method` must be either 'across','chain','aligns_start','aligns_end' or 'inbetween'")
  expect_error(compress_number_line(mtcars, number_line(6, 7), number_line(3, 3)), "'x' is not a number_line object")


})
