% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diversity.R
\name{sim_dataset}
\alias{sim_dataset}
\title{A procedure to simulate datasets}
\usage{
sim_dataset(n_categ, category_prefix = "", entity_prefix = "",
  values = "log-normal", size = -1, mean = 0, sd = 1,
  category_random = FALSE)
}
\arguments{
\item{n_categ}{a vector with number of categories for each entity. The number of entities to create is defined by the length of this vector.}

\item{category_prefix}{a prefix to be used as part of the category label}

\item{entity_prefix}{a prefix to be used as part of the entity label}

\item{values}{values of abundance. This argument can be both, a distribution name or a vector of integers. The distribution is used to simulate individuals that are aggregated in frequencies or values of abundance. Use 'log-normal' for log normal distribution or 'normal' for normal distribution.  In the second case, an integer or a vector of integers of possible values of abundance to be used randomly. Default value is 'log-normal'}

\item{size}{number of individuals. A number or a vector of numbers for each entity. Default value is 7 times variety.}

\item{mean}{parameter for normal or log-normal distribution. Default value is 0.}

\item{sd}{parameter for normal or log-normal distribution. Default value is 1.}

\item{category_random}{boolean argument to determine if categories should be taken randomly (TRUE) or sequentially (FALSE). Default is FALSE}
}
\value{
A data frame with three columns: entity, category and value of abundance.
}
\description{
Simulates a dataset with values of variety for each entity and possible values of abundance.
}
\examples{
sim_dataset(n_categ=50,  category_prefix='ctg', values=1) #equal value, just one entity
#Several entities with random values
n_entities <- 50
v_n_c <- sample(1:100, size = n_entities, replace=TRUE)
v_v <- sample(10:5000, size= n_entities, replace=TRUE)
d <- sim_dataset(n_categ = v_n_c, values= v_v, category_random = TRUE)
}

