% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethod.R
\name{plotTDR,POSIXt,numeric-method}
\alias{plotTDR,POSIXt,numeric-method}
\alias{plotTDR}
\alias{plotTDR,TDR,missing-method}
\alias{plotTDR,TDRcalibrate,missing-method}
\title{Methods for plotting objects of class "TDR" and "TDRcalibrate"}
\usage{
\S4method{plotTDR}{POSIXt,numeric}(
  x,
  y,
  concurVars = NULL,
  xlim = NULL,
  depth.lim = NULL,
  ylab.depth = "depth (m)",
  concurVarTitles = deparse(substitute(concurVars)),
  sunrise.time = "06:00:00",
  sunset.time = "18:00:00",
  night.col = "gray60",
  dry.time = NULL,
  phase.factor = NULL
)

\S4method{plotTDR}{TDR,missing}(x, y, concurVars, concurVarTitles, ...)

\S4method{plotTDR}{TDRcalibrate,missing}(
  x,
  y,
  what = c("phases", "dive.model"),
  diveNo = seq(max(getDAct(x, "dive.id"))),
  ...
)
}
\arguments{
\item{x}{\code{POSIXct} object with date and time, \code{\link{TDR}},
or \code{\link{TDRcalibrate}} object.}

\item{y}{numeric vector with depth in m.}

\item{concurVars}{matrix with additional variables in each column to
plot concurrently with depth.  For the (\code{TDR},\code{missing})
and (\code{TDRcalibrate},\code{missing}) methods, a
\code{\link{character}} vector naming additional variables from the
\code{concurrentData} slot to plot, if any.}

\item{xlim}{\code{POSIXct} or numeric vector of length 2, with lower
and upper limits of time to be plotted.}

\item{depth.lim}{numeric vector of length 2, with the lower and upper
limits of depth to be plotted.}

\item{ylab.depth}{character string to label the corresponding y-axes.}

\item{concurVarTitles}{character vector of titles to label each new
variable given in \var{concurVars}.}

\item{sunrise.time, sunset.time}{character string with time of sunrise
and sunset, respectively, in 24 hr format.  This is used for
shading night time.}

\item{night.col}{color for shading night time.}

\item{dry.time}{subset of time corresponding to observations considered
to be dry.}

\item{phase.factor}{factor dividing rows into sections.}

\item{...}{Arguments for the \code{(POSIXt,numeric)} method.  For
\code{(TDRcalibrate,missing)}, these are arguments for the
appropriate methods.}

\item{what}{character: what aspect of the \code{\link{TDRcalibrate}} to
plot, which selects the method to use for plotting.}

\item{diveNo}{numeric vector or scalar with dive numbers to plot.}
}
\value{
If called with the \code{interact} argument set to \code{TRUE},
    returns a list (invisibly) with as many components as sections of
    the record that were zero-offset corrected, each consisting of two
    further lists with the same components as those returned by
    \code{\link{locator}}.
}
\description{
Main plotting method for objects of these classes.  Plot and optionally
set zero-offset correction windows in \acronym{TDR} records, with the
aid of a graphical user interface (GUI), allowing for dynamic selection
of offset and multiple time windows to perform the adjustment.
}
\section{Methods (by class)}{
\itemize{
\item \code{x = POSIXt,y = numeric}: Base method plotting numeric vector against POSIXt
object

\item \code{x = TDR,y = missing}: Interactive graphical display of time-depth data,
with zooming and panning capabilities.

\item \code{x = TDRcalibrate,y = missing}: plot selected aspects of \code{\link{TDRcalibrate}}
    object.  Currently, two aspects have plotting methods:

* \code{phases} (Optional arguments: \code{concurVars}, \code{surface})
  Plots all dives, labelled by the activity phase they belong to.  It
  produces a plot consisting of one or more panels; the first panel
  shows depth against time, and additional panels show other concurrent
  data in the object.  Optional argument \code{concurVars} is a
  character vector indicating which additional components from the
  \code{concurrentData} slot to plot, if any.  Optional argument
  \code{surface} is a logical: whether to plot surface readings.

* \code{dive.model} Plots the dive model for the selected dive number
  (\code{diveNo} argument).
}}

\examples{
\donttest{## Too long for checks

## Continuing the Example from '?calibrateDepth':
utils::example("calibrateDepth", package="diveMove",
               ask=FALSE, echo=FALSE, run.donttest=TRUE)
## Use interact=TRUE (default) to set an offset interactively
## Plot the 'TDR' object
plotTDR(getTime(divesTDR), getDepth(divesTDR))
plotTDR(divesTDR)

## Plot different aspects of the 'TDRcalibrate' object
plotTDR(dcalib)
plotTDR(dcalib, diveNo=19:25)
plotTDR(dcalib, what="dive.model", diveNo=25)
if (dev.interactive(orNone=TRUE)) {
    ## Add surface observations and interact
    plotTDR(dcalib, surface=TRUE)
    ## Plot one dive
    plotTDR(dcalib, diveNo=200)
}

}
}
\seealso{
\code{\link{calibrateDepth}}, \code{\link{.zoc}}
}
\author{
Sebastian P. Luque \email{spluque@gmail.com}, with many ideas
    from CRAN package sfsmisc.
}
\keyword{iplot}
\keyword{methods}
