% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampstat.R
\name{binstat}
\alias{binstat}
\title{Sampling statistics and diversity indices in every bin}
\usage{
binstat(dat, tax = "genus", bin = "stg", coll = NULL, ref = NULL,
  noNAStart = FALSE, duplicates = NULL, x = NULL, indices = FALSE)
}
\arguments{
\item{dat}{\code{(data.frame)}: The occurrence dataset.}

\item{tax}{\code{(character)}: The column name of taxon names.}

\item{bin}{\code{(character)}: The column name of bin names.}

\item{coll}{\code{(character)}: The column name of collection numbers. (optional)}

\item{ref}{\code{(character)}: The column name of reference numbers. (optional)}

\item{noNAStart}{(logical) Useful when the dataset does not start from bin no. 1, but positive integer bin numbers are provided. Then \code{noNAStart=TRUE} will cut the first part of the resulting table, so the first row will contain the estimates for the lowest bin number. In case of positive integer bin identifiers, and if \code{noNAStart=FALSE}, the index of the row will be the bin number.}

\item{duplicates}{\code{(logical)}: The function will check whether there are duplicate occurrences (multiple species/genera). When set to \code{NULL}, nothing will happen, but the function will notify you if duplicates are present. If set to \code{TRUE}, the function will not do anything with these, if set to \code{FALSE}, the duplicates will be omitted.}

\item{x}{(\code{numeric}): Argument of the OxW subsampling type (\code{\link{subtrialOXW}}).Setting this parameter to a valid numeric value will return the maximum quota for \code{x}.}

\item{indices}{(\code{logical}): Setting this value to \code{TRUE} will calculate all indices implemented in (\code{\link{indices}}).}
}
\description{
This function will return the basic sampling summaries of a dataset
}
\details{
Secondary function of the package that calculates a number of sampling related variables and diversity estimators for each bin. 
In contrast to the (\code{\link{divDyn}}) function, the bins are treated independently in this function.
The function also returns the maximum subsampling quota for OxW subsampling 
(\code{\link{subtrialOXW}}) with a given \code{x} value.

By setting \code{total} to \code{FALSE} (default), the following results are output:

\code{occs}: The number of occurrences in each time bin.

\code{colls}: The number of collections in each time bin.

\code{xQuota}: The maximum quota for OxW subsampling (\code{\link{subtrialOXW}}) with the given \code{x} value. 
	The number of occurrences in each collection is tabulated, and is raised to the power of \code{x}. 
	The \code{xQuota} value is the sum of these values across all collections in a time slice.

\code{refs}: The number of references in each time bin.

\code{SIBs}: The number of Sampled-In-Bin taxa in each time bin.

\code{occ1}: The number of taxa in each time bin, that occur in only 1 collection.

\code{ref1}: The number of taxa in each time bin, that occur in only 1 reference.

\code{occ2}: The number of taxa in each time bin, that occur in exactly 2 collections.

\code{ref2}: The number of taxa in each time bin, that occur in exactly 2 references.

\code{u}: Good's u, coverage estimator based on the number of single-collection taxa (occ1).

\code{uPrime}: Good's u, coverage estimator based on the number of single-reference taxa (ref1).

\code{chao1occ}: Chao1 extrapolation estimator, based on the the number of single-collection and two-collection taxa (occ1).

\code{chao1ref}: Chao1 extrapolation estimator, based on the the number of single-reference and two-reference taxa (occ2).
}
\examples{
data(corals)
# slice-specific sampling
basic <- binstat(corals, tax="genus", bin="stg")

# subsampling diagnostic
 subStats <- subsample(corals, method="cr", tax="genus", FUN=binstat, 
   bin="stg", q=100,noNAStart=FALSE)

# maximum quota with x
more <- binstat(corals, tax="genus", bin="stg", coll="collection_no", x=1.4)

}
