% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affinity.R
\name{affinity}
\alias{affinity}
\title{Calculate environmental affinities of taxa}
\usage{
affinity(dat, env, tax = "genus", bin = "stg", coll = "collection_no",
  method = "binom", alpha = 1, reldat = NULL)
}
\arguments{
\item{dat}{\code{(data.frame)} The occurrence dataset containing the taxa with unknown environmental affinities.}

\item{env}{\code{(character)} The environmental variable of the occurrences.}

\item{tax}{\code{(character)} The column name of taxon names.}

\item{bin}{\code{(character)} The column name of bin names.}

\item{coll}{\code{(character)} The column name of collection numbers.}

\item{method}{\code{(character)} The method used for affinity calculations. Can be either \code{"binom"} or \code{"majority"}.}

\item{alpha}{\code{(numeric)} The alpha value of the binomial tests. By default binomial testing is off (\code{alpha=1}).}

\item{reldat}{\code{(data.frame)} Database with the same structure as \code{dat}. Typically \code{dat} is the subset of \code{reldat}. If given, the occurrence distribution of \code{reldat} is used 
as the null model of sampling.}
}
\description{
This function will return the environmental affinities of taxa, given the sampling conditions implied by the supplied dataset.
}
\details{
Sampling patterns have an overprinting effect on the frequency of taxon occurrences in different environments. The environmental affinity (Foote, 2006; Kiessling and Aberhan, 2007; Kiessling and Kocsis, 2015) expresses whether the taxa are more likely to occur in an environment, given the sampling patterns of the dataset at hand. The function returns the likely preferred environment for each taxon as a vector. \code{NA} outputs indicate that the environmental affinity is equivocal based on the selected method.

\strong{The following methods are implemented:}

\code{'majority'}: Environmental affinity will be assigned based on the number of occurrences of the taxon in the different environments, without taking sampling of the entire dataset into account. If the taxon has more occurrences in \emph{environment 1}, the function will return \emph{environment 1} as the preferred habitat.

\code{'binom'}: The proportion of occurrences of a taxon in \emph{environment 1} and \emph{environment 2} will be compared to a null model, which is based on the distribution of all occurrences from the stratigraphic range of the taxon. The \code{alpha} value indicates the significance of the binomial tests, setting \code{alpha} to \code{1} will effectively switch the testing off: if the ratio of occurrences for the taxon is different from the ratio observed in the dataset, an affinity will be assigned. This is the default method.

\strong{References}

Foote, M. (2006). Substrate affinity and diversity dynamics of Paleozoic marine animals. Paleobiology, 32(3), 345-366.

Kiessling, W., & Aberhan, M. (2007). Environmental determinants of marine benthic biodiversity dynamics through Triassic–Jurassic time. Paleobiology, 33(3), 414-434.

Kiessling, W., & Kocsis, Á. T. (2015). Biodiversity dynamics and environmental occupancy of fossil azooxanthellate and zooxanthellate scleractinian corals. Paleobiology, 41(3), 402-414.
}
\examples{
data(corals)
# omit values where no occurrence environment entry is present, or where unknown
  fossils<-subset(corals, stg!=95)
  fossilEnv<-subset(fossils, bath!="uk")
# calculate affinities
  aff<-affinity(fossilEnv, env="bath", tax="genus", bin="stg", alpha=1)

}
