% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testParameterSet}
\alias{testParameterSet}
\alias{checkParameterSet}
\alias{assertParameterSet}
\title{assert/check/test/ParameterSet}
\usage{
testParameterSet(
  object,
  errormsg = paste(object, "is not an R6 ParameterSet object")
)

checkParameterSet(
  object,
  errormsg = paste(object, "is not an R6 ParameterSet object")
)

assertParameterSet(
  object,
  errormsg = paste(object, "is not an R6 ParameterSet object")
)
}
\arguments{
\item{object}{object to test}

\item{errormsg}{custom error message to return if assert/check fails}
}
\value{
If check passes then \code{assert} returns invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is a \link{ParameterSet}.
}
\examples{
testParameterSet(5) # FALSE
testParameterSet(Binomial$new()$parameters()) # TRUE
}
