library(testthat)

context("Noncentral F distribution")

test_that("parameterisation", {
  expect_silent(FDistributionNoncentral$new())
  expect_silent(FDistributionNoncentral$new(df1 = 3, df2 = 5, location = 2))
  expect_error(FDistributionNoncentral$new(df1 = 1, df2 = -1))
  expect_error(FDistributionNoncentral$new(df1 = -1, df2 = 1))
  expect_error(FDistributionNoncentral$new(location = -2))
  expect_equal(FDistributionNoncentral$new(df1 = 10, df2 = 5)$getParameterValue("df1"), 10)
  expect_equal(FDistributionNoncentral$new(df1 = 10, df2 = 5)$getParameterValue("df2"), 5)
  expect_equal(FDistributionNoncentral$new(df1 = 8.1, df2 = 3.6)$getParameterValue("df1"), 8.1)
  expect_equal(FDistributionNoncentral$new(df1 = 8.1, df2 = 3.6)$getParameterValue("df2"), 3.6)
  expect_equal(FDistributionNoncentral$new(location = 3)$getParameterValue("location"), 3)
})

test_that("properties & traits", {
  expect_equal(FDistributionNoncentral$new()$valueSupport, "continuous")
  expect_equal(FDistributionNoncentral$new()$variateForm, "univariate")
  expect_equal(FDistributionNoncentral$new()$symmetry, "asymmetric")
  expect_equal(FDistributionNoncentral$new()$sup, Inf)
  expect_equal(FDistributionNoncentral$new()$inf, 0)
  expect_equal(FDistributionNoncentral$new()$dmax, Inf)
  expect_equal(FDistributionNoncentral$new()$dmin, 0)
  expect_equal(FDistributionNoncentral$new(df1 = 5, df2 = 5)$dmax, Inf)
  expect_equal(FDistributionNoncentral$new(df1 = 5, df2 = 5)$dmin, .Machine$double.eps)
})

f <- FDistributionNoncentral$new(df1 = 1, df2 = 5, location = 2)
test_that("statistics", {
  expect_equal(f$mean(), 5)
  expect_equal(FDistributionNoncentral$new(df2 = 2)$mean(), NaN)
  expect_equal(f$variance(), 400/3)
  expect_equal(FDistributionNoncentral$new(df2 = 2)$variance(), NaN)
  expect_error(f$skewness())
  expect_error(f$kurtosis())
  expect_error(f$entropy())
  expect_error(f$mode())
  expect_error(f$mgf())
  expect_error(f$cf())
  expect_error(f$pgf())
  expect_equal(f$pdf(1), df(1, 1, 5, 2))
  expect_equal(f$cdf(1), pf(1, 1, 5, 2))
  expect_equal(f$quantile(0.3), qf(0.3, 1, 5, 2))
  expect_equal(f$cdf(f$quantile(0.3)), 0.3)
  expect_silent(f$rand(10))
})
