% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disto_methods.R
\name{`[<-.disto`}
\alias{`[<-.disto`}
\alias{[<-.disto}
\title{In-place replacement of values}
\usage{
\method{[}{disto}(x, i, j, k) <- value
}
\arguments{
\item{x}{object of class 'disto'}

\item{i}{(integer vector) row index}

\item{j}{(integer vector) column index}

\item{k}{(integer vector) direct index}

\item{value}{(integer/numeric vector) Values to replace}
}
\value{
Invisible disto object. Note that this function is called for its
  side effect.
}
\description{
For dist backend see: \code{\link{dist_replace}}.
}
\examples{
temp       <- stats::dist(iris[,1:4])
dio        <- disto(objectname = "temp")
names(dio) <- paste0("a", 1:150)
dio

dio[1, 2] <- 10
dio[1,2]

dio[1:10, 2:11] <- 100
dio[1:10, 2:11, product = "inner"]

dio[paste0("a", 1:5), paste0("a", 6:10)] <- 101
dio[paste0("a", 1:5), paste0("a", 6:10), product = "inner"]
}
