% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotter.R
\name{predict_ICE.Plotter}
\alias{predict_ICE.Plotter}
\title{Prediction Function for ICE Plots}
\usage{
predict_ICE.Plotter(object, features = NULL, save = TRUE)
}
\arguments{
\item{object}{The Interpeter object to use.}

\item{features}{A vector with the names of the features to predict ICE plots for}

\item{save}{A boolean indicator to indicate whether the calculations should be
saved in the interpreter object or not. This can help reduce
computation if the ICE functions are used many times, but requires
additional memory to store the predictions. By default, this is TRUE.}
}
\value{
A list of data frames, one for each feature. In each data frame, the first
        column contains the grid values for the feature, and each subsequent
        column has a single observation corresponding to the prediction of the model
        when with the given feature set to that grid point value.
}
\description{
Gives predictions at each point on the grid.
}
\note{
This method is meant to primarily be used to find the exact values for the ICE
curves plotted. Note that after the PDP curve is plotted, the returned
object of this function will be the saved predictions for plotting the curve, rather
than a recalculation of the values.
}
