% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotter.R
\name{ale}
\alias{ale}
\title{Constructs an ALE for a model.}
\usage{
ale(
  predict_function,
  num_grid_points,
  training_data,
  variable_names,
  center = "zero",
  grid_points,
  window_size
)
}
\arguments{
\item{predict_function}{a function taking a single tibble argument and returning the model
predictions corresponding to that tibble.}

\item{num_grid_points}{the number of grid_points at which to construct the ALE}

\item{training_data}{the training data used to fit the model}

\item{variable_names}{a vector of feature names in training data for which an ALE is required.}

\item{center}{one of "uncentered" meaning the plots are not centered, "mean"
meaning the plots are centered at their mean and "zero" meaning the ALE
passes through the origin. When using center == "zero" we recommend setting
window_size because otherwise a smaller and possibly empty set will be used
to compute the ALE at zero.}

\item{grid_points}{The grid points to use for the AlE calculation.}

\item{window_size}{the fraction of the data (between zero and one) used to compute each ALE point.}
}
\description{
Constructs an ALE for a model.
}
