% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{rename_post_dir}
\alias{rename_post_dir}
\title{Rename a blog post directory}
\usage{
rename_post_dir(post_dir, slug = "auto", date_prefix = "auto")
}
\arguments{
\item{post_dir}{Path to post directory}

\item{slug}{Post slug (directory name). Automatically computed from title if not
provided.}

\item{date_prefix}{Date prefix for post. Defaults to the post's date
field (or the current date if there is none). Pass \code{NULL} to not
use a date prefix.}
}
\description{
Rename a blog post directory, by default using the title and date
specified within the post's front matter.
}
\note{
This function must be called from with a working directory that is within
a Distill website.
}
\examples{
\dontrun{
library(distill)
rename_post_dir("_posts/2020-09-12-my-post")
rename_post_dir("_posts/2020-09-12-my-post", date_prefix = "9/15/2020")
}

}
