% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cost_path_trim_cpp}
\alias{cost_path_trim_cpp}
\title{(C++) Remove Blocks from a Least Cost Path}
\usage{
cost_path_trim_cpp(path)
}
\arguments{
\item{path}{(required, data frame) least-cost path produced by \code{\link[=cost_path_orthogonal_cpp]{cost_path_orthogonal_cpp()}}.}
}
\value{
data frame
}
\description{
(C++) Remove Blocks from a Least Cost Path
}
\examples{
#simulate two time series
x <- zoo_simulate(seed = 1)
y <- zoo_simulate(seed = 2)

#distance matrix
dist_matrix <- distance_matrix_cpp(
  x = x,
  y = y,
  distance = "euclidean"
)

#least cost matrix
cost_matrix <- cost_matrix_orthogonal_cpp(
  dist_matrix = dist_matrix
)

#least cost path
cost_path <- cost_path_slotting_cpp(
  dist_matrix = dist_matrix,
  cost_matrix = cost_matrix
)

nrow(cost_path)

#remove blocks from least-cost path
cost_path_trimmed <- cost_path_trim_cpp(
  path = cost_path
)

nrow(cost_path_trimmed)
}
\seealso{
Other Rcpp_cost_path: 
\code{\link{cost_path_cpp}()},
\code{\link{cost_path_diagonal_bandwidth_cpp}()},
\code{\link{cost_path_diagonal_cpp}()},
\code{\link{cost_path_orthogonal_bandwidth_cpp}()},
\code{\link{cost_path_orthogonal_cpp}()},
\code{\link{cost_path_slotting_cpp}()},
\code{\link{cost_path_sum_cpp}()}
}
\concept{Rcpp_cost_path}
