% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{delete_duplicates_DF}
\alias{delete_duplicates_DF}
\title{Delete rows with duplicated values}
\usage{
delete_duplicates_DF(
  data,
  duplicated.var,
  exact = FALSE,
  stay = "first",
  choose.var,
  choose.stay.val,
  pattern,
  mc.cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{data}{data frame;}

\item{duplicated.var}{variable that contains duplicated values}

\item{exact}{logical; values are to be matched as is}

\item{stay}{character; which row with duplicated values will stay; possible values are \code{"first"} (first of rows),
\code{"choose"} (depending of the value of other variable) and \code{"none"} (rows with values that contain pattern will be removed)}

\item{choose.var, choose.stay.val}{vector of additional variable to choose the preferred row and it's preferred value
(used if \code{stay = "choose"})}

\item{pattern}{deleted pattern (used if \code{stay = "none"})}

\item{mc.cores}{integer; number of processors for parallel computation (not supported on Windows)}

\item{verbose}{logical; show messages}
}
\value{
Data frame without rows that contain duplicates in \code{duplicated.var}
}
\description{
Delete data frame rows if they contain duplicated values.
}
\details{
This function checks if there are repeated values in the data frame (in the \code{duplicated.var}).
If repeated values are found, the first row with duplicated value stays, others are deleted (if \code{stay = "first"}).
If \code{stay = "choose"} the first row with duplicated values and \code{choose.var = choose.stay.val} will stay.
If there are no rows with \code{choose.var = choose.stay.val}, the first row will stay.

If \code{stay = "none"} all rows with values that contain pattern will be removed.
}
\examples{
data <- data.frame (N = c(1:5, 11:15), name = c(rep( "A",4), "AA", rep( "B",3), "BB", "C"),
                choose = c(rep(c("yes", "no"), 3), "yes", "yes", "no", "no"))
delete_duplicates_DF (data = data, duplicated.var = data$N, exact = TRUE, stay = "first")
delete_duplicates_DF (data = data, duplicated.var = data$N, exact = FALSE, stay = "first")
delete_duplicates_DF (data = data, duplicated.var = data$name, exact = TRUE, stay = "first")
delete_duplicates_DF (data = data, duplicated.var = data$name, exact = TRUE,
                    stay = "choose", choose.var = data$choose, choose.stay.val = "yes")
delete_duplicates_DF (data = data, duplicated.var = data$name, exact = FALSE, stay = "first")
delete_duplicates_DF (data = data, duplicated.var = data$name, exact = FALSE,
                    stay = "choose", choose.var = data$choose, choose.stay.val = "yes")
delete_duplicates_DF (data =data, duplicated.var = data$name, stay = "none",
                    pattern = c("A", "B"), exact = TRUE)
delete_duplicates_DF (data =data, duplicated.var = data$name, stay = "none",
                    pattern = c("A", "B"), exact = FALSE)

}
\author{
Elena N. Filatova
}
