% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloads.R
\name{annotate_probes}
\alias{annotate_probes}
\title{Annotate probes}
\usage{
annotate_probes(
  source = "data.frame",
  ann.data = NULL,
  gff.path = NULL,
  org.name,
  db = "refseq",
  refs = TRUE,
  probe.id.var,
  probe.start.var,
  probe.stop.var,
  file.annot = NULL,
  save.format = "txt",
  sep = ";",
  return = "add.resume",
  priority = c("CDS", "gene", "region"),
  data,
  data.probe.id.var,
  delete.downloads = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{source}{character; genome annotation source. Possible values are:
\code{"data.frame"} (from data frame), \code{"giff"} (from GIFF file),
\code{"load"} (download from NCBI with \link[biomartr]{getGFF} function)}

\item{ann.data}{genome annotation data frame}

\item{gff.path}{character; .gff file name and path}

\item{org.name}{character; the scientific name of the organism of interest}

\item{db}{character; database from which the genome shall be retrieved; possible values are \code{"refseq", "genbank", "ensembl"}}

\item{refs}{logical; download genome if it isn't marked in the database as either a reference or a representative genome}

\item{probe.id.var}{vector of probes' identification numbers}

\item{probe.start.var, probe.stop.var}{integer; vector of probes' start and end coordinates}

\item{file.annot}{character; resulting annotation file name and path}

\item{save.format}{character; format of resulting annotation file; possible values are \code{"txt", "csv"}}

\item{sep}{character;  field separator string}

\item{return}{character; returned object; possible values are: \code{"annotation"} (annotation data frame),
\code{"resume"} (annotation attributes only), \code{"add.resume"} (user's data frame with added annotation attributes)}

\item{priority}{character; vector of sequence ontology types that should be returned in resume in the first place}

\item{data, data.probe.id.var}{users data frame and probes' identification variable in it (used if \code{return = "add.resume"})}

\item{delete.downloads}{logical; delete files that were downloaded from NCBI}

\item{verbose}{logical; show messages}
}
\value{
Annotation data frame, or annotation attributes, or user's data frame with added annotation attributes. Also annotation file is created.
}
\description{
Get genome annotation for oligonucleotide sequence
}
\details{
This function uses \code{boimartr} genome annotation retrieval instruments. See \link[biomartr]{getGFF} for details.
If retrieval is not available, GFF file may be used.

This function creates annotation ".txt" or ".csv" file. By default file is created in working directory.
Optionally function returns annotation resume, i.e. annotation attribute for specified sequence ontology (SO).
Priorities of SOs are set by user in \code{priopity} parameter.
For example, if \code{priopity = c("CDS", "gene", "region")}, the function returns resume for "CDS" CO, if there are none - for
"gene" CO etc.
If there are several attributes meet \code{priority}, the first annotation attribute is returned.
If none of \code{priority} COs found, the first annotation attribute is returned.

Number of found annotations are indicated in returned data (\code{"ann.n" column}).
}
\examples{
path<-tempdir()
dir.create(path) # create temporal directory
data(ann.data) # load genome annotation data frame
annotation<-annotate_probes(source = "data.frame", ann.data = ann.data,
                probe.id.var = 1:5,
                probe.start.var = c (1, 100, 200, 300, 400),
                probe.stop.var = c (99, 199, 299, 399, 499),
                file.annot = paste0(path, "/annotation.txt"), save.format = "txt",
                return = "resume")
file.remove(paste0(path, "/annotation.txt")) # delete files
unlink(path, recursive = TRUE)

}
\author{
Elena N. Filatova
}
