% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorph.ordination.R
\name{geomorph.ordination}
\alias{geomorph.ordination}
\title{Imports data from geomorph}
\usage{
geomorph.ordination(data, ordinate = TRUE, ...)
}
\arguments{
\item{data}{An array (p x k x n) typically obtained from a Procrustes superimposition \code{geomorph::gpagen} or a \code{geomorph::geomorph.data.frame} object.}

\item{ordinate}{Logical, whether to ordinate the data using \code{\link[stats]{prcomp}} (\code{TRUE}; default) or not (\code{FALSE}; the code then returns the raw coordinates matrix).}

\item{...}{Any optional arguments to be passed to \code{\link[stats]{prcomp}} (is ignored if \code{ordinate = FALSE}).}
}
\value{
A \code{matrix} or a \code{dispRity} object.
}
\description{
Takes geomorph Procrustes object or a geomorph.data.frame object and ordinates it.
}
\details{
If \code{data} is a \code{geomorph.data.frame} object containing factors, directly performs a \code{\link{custom.subsets}} using these factors.
}
\examples{
\dontrun{
require(geomorph)
## Loading the plethodon dataset
data(plethodon)

## Performing a Procrustes transform
procrustes <- geomorph::gpagen(plethodon$land, PrinAxes = FALSE)

## Obtaining the ordination matrix
geomorph.ordination(procrustes)

## Using a geomorph.data.frame
geomorph_df <- geomorph.data.frame(procrustes, species = plethodon$species)

geomorph.ordination(geomorph_df)

## Calculating disparity from dispRity or geomorph::morphol.disparity
geomorph_disparity <- geomorph::morphol.disparity(coords ~ 1,
                      groups= ~ species, data = geomorph_df)
dispRity_disparity <- dispRity(geomorph.ordination(geomorph_df),
                      metric = function(X) return(sum(X^2)/nrow(X)))

## Extracting the raw disparity values
geomorph_val <- round(as.numeric(geomorph_disparity$Procrustes.var), 15)
dispRity_val <- as.vector(summary(dispRity_disparity, digits = 15)$obs)

## Comparing the values (to the 15th decimal!)
geomorph_val == dispRity_val # all TRUE
}

}
\seealso{
\code{geomorph::gpagen}, \code{geomorph::morphol.disparity}, \code{\link[stats]{prcomp}}, \code{\link{custom.subsets}}, \code{\link{chrono.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity}}.
}
