% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom.subsets.R
\name{custom.subsets}
\alias{custom.subsets}
\alias{cust.series}
\alias{custom.series}
\alias{cust.subsets}
\title{Separating data into custom subsets.}
\usage{
custom.subsets(data, group)
}
\arguments{
\item{data}{A \code{matrix} (see details).}

\item{group}{Either a \code{list} of row numbers or names to be used as different groups or a \code{data.frame} with the same \eqn{k} elements as in \code{data} as rownames. If \code{group} is a \code{phylo} object matching \code{data}, groups are automatically generated as clades.}
}
\value{
This function outputs a \code{dispRity} object containing:
\item{matrix}{the multidimensional space (a \code{matrix}).}
\item{call}{A \code{list} containing the called arguments.}
\item{subsets}{A \code{list} containing matrices pointing to the elements present in each subsets.}

Use \link{summary.dispRity} to summarise the \code{dispRity} object.
}
\description{
Splits the data into a customized subsets list.
}
\details{
The data is considered as the multidimensional space with rows as elements and columns as dimensions and is not transformed (e.g. if ordinated with negative eigen values, no correction is applied to the matrix).

Note that every element from the input data can be assigned to multiple groups!
}
\examples{
## Generating a dummy ordinated matrix
ordinated_matrix <- matrix(data = rnorm(90), nrow = 10)

## Splitting the ordinated matrix into two groups using row numbers
custom.subsets(ordinated_matrix, list(c(1:4), c(5:10)))

## Splitting the ordinated matrix into three groups using row names
ordinated_matrix <- matrix(data = rnorm(90), nrow = 10,
     dimnames = list(letters[1:10]))
custom.subsets(ordinated_matrix,
     list("A" = c("a", "b", "c", "d"), "B" = c("e", "f", "g", "h", "i", "j"),
          "C" = c("a", "c", "d", "f", "h")))

## Splitting the ordinated matrix into four groups using a dataframe
groups <- as.data.frame(matrix(data = c(rep(1,5), rep(2,5), rep(c(1,2), 5)),
     nrow = 10, ncol = 2, dimnames = list(letters[1:10], c("g1", "g2"))))
custom.subsets(ordinated_matrix, groups)

## Splitting a matrix by clade
data(BeckLee_mat50)
data(BeckLee_tree)
custom.subsets(BeckLee_mat50, group = BeckLee_tree)


}
\seealso{
\code{\link{chrono.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity}}, \code{\link{crown.stem}}.
}
\author{
Thomas Guillerme
}
